/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.signing;

import com.peterphi.std.crypto.keystore.Keystore;
import com.peterphi.std.net.IpHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLDocumentSigner {
    private static final Logger log = Logger.getLogger(XMLDocumentSigner.class);
    private static int seq = 0;
    private static double instanceId = Math.random();
    private final Document doc;

    public XMLDocumentSigner(String xml) throws Exception {
        assert (xml != null) : "XML string must be provided";
        assert (xml.length() != 0) : "XML string must not be empty";
        try {
            Document xmlDoc;
            log.debug((Object)"[XmlDocSigner] <ctor> Constructing document builder factory");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            log.debug((Object)"[XmlDocSigner] <ctor> Reading document");
            InputSource is = new InputSource(new StringReader(xml));
            this.doc = xmlDoc = dbf.newDocumentBuilder().parse(is);
        }
        catch (Exception e) {
            log.error((Object)("[XMLDocumentSigning] {ctor} Could not load XML document: " + e.getMessage()), (Throwable)e);
            throw new Exception("Could not load the XML document: " + e.getMessage(), e);
        }
    }

    public XMLDocumentSigner(File xmlFile) throws Exception {
        assert (xmlFile != null) : "File must be provided";
        assert (xmlFile.exists()) : "XML file must exist";
        try {
            Document xmlDoc;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            this.doc = xmlDoc = dbf.newDocumentBuilder().parse(new FileInputStream(xmlFile));
        }
        catch (Exception e) {
            log.error((Object)("[XMLDocumentSigning] {ctor} Could not load XML document: " + e.getMessage()), (Throwable)e);
            throw new Exception("Could not load the XML document: " + e.getMessage(), e);
        }
    }

    public XMLDocumentSigner(Document d) {
        assert (d != null) : "XML Document must be provided";
        this.doc = d;
    }

    public Document sign(String machineId, KeyPair keys) {
        return this.sign(machineId, keys.getPublic(), keys.getPrivate());
    }

    public static KeyPair getKeypair(KeyStore ks, String alias, char[] passphrase) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        KeyStore.Entry e = ks.getEntry(alias, new KeyStore.PasswordProtection(passphrase));
        KeyStore.PrivateKeyEntry pkEntry = (KeyStore.PrivateKeyEntry)e;
        PublicKey pubkey = pkEntry.getCertificate().getPublicKey();
        PrivateKey privkey = pkEntry.getPrivateKey();
        return new KeyPair(pubkey, privkey);
    }

    public Document sign(String machineId, PublicKey publicKey, PrivateKey privateKey) {
        try {
            String baseUri = "";
            XMLSignature signature = new XMLSignature(this.doc, baseUri, "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512");
            this.doc.getFirstChild().appendChild(signature.getElement());
            Transforms transforms = new Transforms(this.doc);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            transforms.addTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
            signature.addDocument(baseUri, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            String signatureId = "id:" + machineId + " ";
            signatureId = signatureId + "ip:" + IpHelper.getLocalIp() + " ";
            signatureId = signatureId + "inst:" + instanceId + " ";
            signatureId = signatureId + "seq:" + ++seq + " ";
            signatureId = signatureId + "now:" + System.currentTimeMillis();
            signature.setId(signatureId);
            signature.addKeyInfo(publicKey);
            signature.sign((Key)privateKey);
            log.info((Object)("[XMLDocumentSigner] {sign} Issued signature " + signatureId));
            return signature.getDocument();
        }
        catch (XMLSecurityException e) {
            log.error((Object)("[XMLDocumentSigning] {sign} Error signing document: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public boolean save(File dest) {
        if (dest.exists()) {
            dest.delete();
        }
        try {
            XMLUtils.outputDOMc14nWithComments((Node)this.doc, (OutputStream)new FileOutputStream(dest));
            return true;
        }
        catch (FileNotFoundException e) {
            log.error((Object)("[XMLDocumentSigner] {save} Couldn't save to file " + dest));
            return false;
        }
    }

    public Document stripSignature() {
        if (this.hasSignature()) {
            Element sig = (Element)this.doc.getLastChild().getLastChild();
            sig.getParentNode().removeChild(sig);
        } else {
            log.warn((Object)"[XMLDocumentSigner] {stripSignature} Signature not found: nothing stripped");
        }
        return this.doc;
    }

    public boolean hasSignature() {
        Element e;
        Node n = this.doc.getLastChild().getLastChild();
        return n instanceof Element && (e = (Element)n).getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && e.getLocalName().equals("Signature");
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLUtils.outputDOMc14nWithComments((Node)this.doc, (OutputStream)bos);
        return bos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate(Keystore truststore) throws CertificateException, FileNotFoundException, IOException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream tsis = null;
        try {
            tsis = new FileInputStream(truststore.file);
            KeyStore ts = KeyStore.getInstance(truststore.getType());
            ts.load(tsis, truststore.password.toCharArray());
            ArrayList<PublicKey> keys = new ArrayList<PublicKey>();
            Enumeration<String> aliases = ts.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                PublicKey pk = ts.getCertificate(alias).getPublicKey();
                if (pk == null) continue;
                keys.add(pk);
            }
            PublicKey[] keyarray = new PublicKey[keys.size()];
            for (int i = 0; i < keyarray.length; ++i) {
                keyarray[i] = (PublicKey)keys.get(i);
            }
            boolean bl = this.validate(keyarray);
            return bl;
        }
        finally {
            try {
                if (tsis != null) {
                    tsis.close();
                }
            }
            catch (IOException e) {
                log.warn((Object)("[XMLDocumentSigner] {validate} Error closing truststore file: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public boolean validate(PublicKey ... allowedKeys) {
        Element sigElement = (Element)this.doc.getLastChild().getLastChild();
        try {
            XMLSignature signature = new XMLSignature(sigElement, "");
            for (PublicKey element : allowedKeys) {
                try {
                    boolean validationResult;
                    if (element == null || !(validationResult = signature.checkSignatureValue((Key)element))) continue;
                    return true;
                }
                catch (XMLSignatureException e) {
                    log.error((Object)("[XMLDocumentSigning] {validate} Error with signature/key combo: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (XMLSecurityException ex) {
            log.error((Object)"[XMLDocumentSigning] {validate} Error loading signature from document");
            return false;
        }
        return false;
    }

    static {
        log.debug((Object)"[XMLDocumentSigning] <init> Initialising apache xml security");
        Init.init();
        log.debug((Object)"[XMLDocumentSigning] <init> Apache xml security initialised.");
        if (Security.getProvider("BC") == null) {
            log.info((Object)"[XMLDocumentSigner] Loading Bouncy Castle Provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
            log.debug((Object)"[XMLDocumentSigner] Bouncy Castle Provider loaded");
        }
        log.info((Object)("[XMLDocumentSigner] initialised. instanceId is " + instanceId));
    }
}

