/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.openssl;

import com.peterphi.std.system.exec.Exec;
import com.peterphi.std.system.exec.Execed;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.log4j.Logger;

public class OpenSSLPKCS12 {
    private static final Logger log = Logger.getLogger(OpenSSLPKCS12.class);
    public static final String OPENSSL = "openssl";
    public static final boolean USE_GENERIC_TEMP_DIRECTORY = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterP12(File p12, String p12Password) throws IOException {
        if (!p12.exists()) {
            throw new IllegalArgumentException("p12 file does not exist: " + p12.getPath());
        }
        File pem = new File(p12.getAbsolutePath() + ".pem.tmp");
        String pemPassword = UUID.randomUUID().toString();
        try {
            OpenSSLPKCS12.P12toPEM(p12, p12Password, pem, pemPassword);
            OpenSSLPKCS12.PEMtoP12(pem, pemPassword, p12, p12Password);
        }
        finally {
            if (pem.exists() && !pem.delete()) {
                log.warn((Object)("[OpenSSLPKCS12] {filterP12} Could not delete temporary PEM file " + pem));
            }
        }
    }

    public static void P12toPEM(File p12, String p12Password, File toPEM, String pemPassword) throws IOException {
        if (!p12.exists()) {
            throw new IllegalArgumentException("p12 file does not exist: " + p12.getPath());
        }
        Execed openssl = Exec.utilityAs(null, OPENSSL, "pkcs12", "-in", p12.getPath(), "-out", toPEM.getPath(), "-passin", "pass:" + p12Password, "-nodes");
        int returnCode = openssl.waitForExit();
        if (returnCode != 0) {
            throw new IllegalStateException("Unexpected openssl exit code " + returnCode + "; output:\n" + openssl.getStandardOut());
        }
    }

    public static void PEMtoP12(File pem, String pemPassword, File toP12, String p12Password) throws IOException {
        if (!pem.exists()) {
            throw new IllegalArgumentException("pem file does not exist: " + pem.getPath());
        }
        Execed openssl = Exec.utilityAs(null, OPENSSL, "pkcs12", "-nodes", "-in", pem.getPath(), "-out", toP12.getPath(), "-export", "-passin", "pass:" + pemPassword, "-passout", "pass:" + p12Password);
        int returnCode = openssl.waitForExit();
        if (returnCode != 0) {
            throw new IllegalStateException("Unexpected openssl exit code " + returnCode + "; output:\n" + openssl.getStandardOut());
        }
    }
}

