/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import java.io.File;
import java.io.Serializable;

public class Keystore
implements Serializable {
    private static final long serialVersionUID = 1L;
    public File file;
    public String password = "";
    public String type = "JKS";

    public Keystore() {
    }

    public Keystore(String type, File file, String password) {
        this.type = type;
        this.file = file;
        this.password = password;
    }

    public String getType() {
        return this.type;
    }

    public File getFile() {
        return this.file;
    }

    public String getPassword() {
        return this.password;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean exists() {
        if (this.file != null) {
            return this.file.exists();
        }
        return false;
    }

    public String toString() {
        return "keystore-" + this.type + ":" + this.file.getPath();
    }

    public void readFromSystem(boolean truststore) {
        String propName = truststore ? "javax.net.ssl.trustStore" : "javax.net.ssl.keyStore";
        String tsName = System.getProperty(propName);
        if (tsName != null && tsName.length() > 0) {
            File tsFile = new File(tsName);
            this.setFile(tsFile);
        }
        this.setType(System.getProperty(propName + "Type"));
        this.setPassword(System.getProperty(propName + "Password"));
    }

    public void writeToSystem(boolean truststore) {
        String propName;
        String string = propName = truststore ? "javax.net.ssl.trustStore" : "javax.net.ssl.keyStore";
        if (this.getFile() != null) {
            System.setProperty(propName, this.getFile().getPath());
        }
        if (this.getType() != null) {
            System.setProperty(propName + "Type", this.getType());
        }
        if (this.getPassword() != null) {
            System.setProperty(propName + "Password", this.getPassword());
        }
    }
}

