/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import com.peterphi.std.crypto.digest.KeyFingerprinting;
import com.peterphi.std.crypto.keystore.PKCS8Util;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FingerprintKeyStorage {
    private static final transient Logger log = Logger.getLogger(FingerprintKeyStorage.class);
    private static final String keyFileExtension = ".pkcs8";
    private final Map<String, KeyPair> _storage = new HashMap<String, KeyPair>();
    private final File directory;

    public FingerprintKeyStorage(File directory) {
        this.directory = directory;
        if (!directory.exists()) {
            directory.mkdirs();
        }
        this.scanAll();
    }

    protected void scanAll() {
        this._storage.clear();
        File[] files = this.directory.listFiles();
        if (files == null) {
            log.warn((Object)("{scanAll} null result from listFiles on " + this.directory.getAbsolutePath()));
        }
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().toLowerCase().endsWith(keyFileExtension)) continue;
                try {
                    KeyPair keypair = PKCS8Util.toKeyPair(file);
                    if (keypair == null) continue;
                    this.add(keypair);
                }
                catch (IOException e) {
                    log.warn((Object)("{scanAll} Error loading key from " + file.getAbsolutePath() + ". Error: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public KeyPair get(String fingerprint) {
        return this._storage.get(FingerprintKeyStorage.normalise(fingerprint));
    }

    public Set<KeyPair> getAll() {
        Collection<KeyPair> values = this._storage.values();
        HashSet<KeyPair> copy = new HashSet<KeyPair>(values);
        return Collections.unmodifiableSet(copy);
    }

    public boolean contains(String fingerprint) {
        return this._storage.containsKey(FingerprintKeyStorage.normalise(fingerprint));
    }

    public void add(KeyPair keypair) {
        String fingerprint = FingerprintKeyStorage.fingerprint(keypair);
        if (log.isInfoEnabled()) {
            log.info((Object)("{add} Adding keypair with fingerprint: " + fingerprint));
        }
        this.writeFile(fingerprint, keypair);
        this._storage.put(fingerprint, keypair);
    }

    public void remove(KeyPair keypair) {
        String fingerprint = FingerprintKeyStorage.fingerprint(keypair);
        this.deleteFile(fingerprint, keypair);
        this._storage.remove(fingerprint);
    }

    public void clear() {
        for (KeyPair keypair : this.getAll()) {
            this.remove(keypair);
        }
    }

    public int size() {
        return this._storage.size();
    }

    protected void deleteFile(String fingerprint, KeyPair keypair) {
        File file = this.getFile(fingerprint, keypair);
        file.delete();
    }

    protected File getFile(String fingerprint, KeyPair keypair) {
        String filename = fingerprint + keyFileExtension;
        File file = new File(this.directory, filename);
        return file;
    }

    protected void writeFile(String fingerprint, KeyPair keypair) {
        File file = this.getFile(fingerprint, keypair);
        try {
            PKCS8Util.toFile(keypair, file);
        }
        catch (IOException e) {
            String absolutePath = file.getAbsolutePath();
            file.delete();
            throw new RuntimeException("Error writing keypair to file " + absolutePath + ": " + e.getMessage());
        }
    }

    public boolean contains(KeyPair keypair) {
        return this.contains(FingerprintKeyStorage.fingerprint(keypair));
    }

    public void addAll(Iterable<KeyPair> keypairs) {
        for (KeyPair keypair : keypairs) {
            this.add(keypair);
        }
    }

    public void remove(String fingerprint) {
        KeyPair keypair = this.get(fingerprint);
        this.remove(keypair);
    }

    public void removeAll(Iterable<KeyPair> keypairs) {
        for (KeyPair keypair : keypairs) {
            this.remove(keypair);
        }
    }

    protected static String fingerprint(KeyPair keypair) {
        return FingerprintKeyStorage.normalise(KeyFingerprinting.fingerprint(keypair));
    }

    protected static String normalise(String fingerprint) {
        return fingerprint.toLowerCase().replace(":", "");
    }
}

