/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keygen.ca;

import com.peterphi.std.crypto.keygen.CaHelper;
import com.peterphi.std.crypto.keygen.ca.CertificateAuthority;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.openssl.PEMWriter;

public class IssuedCertificate {
    public KeyPair keypair;
    public X509Certificate mycert;
    public X509Certificate cacert;

    public IssuedCertificate(X509Certificate ca, KeyPair keypair, X509Certificate certificate) {
        this.cacert = ca;
        this.keypair = keypair;
        this.mycert = certificate;
    }

    public void saveP12(File p12) throws Exception {
        this.saveP12(p12, new char[0]);
    }

    public void saveP12(File p12, char[] pass) throws Exception {
        FileOutputStream os = new FileOutputStream(p12);
        this.saveP12(os, pass);
        ((OutputStream)os).close();
    }

    public void saveP12(OutputStream os, char[] pass) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12", CertificateAuthority.PROVIDER);
        ks.load(null, null);
        ks.setCertificateEntry("", this.cacert);
        ks.setCertificateEntry("", this.mycert);
        ks.setKeyEntry("", this.keypair.getPrivate(), new char[0], new Certificate[]{this.mycert, this.cacert});
        ks.store(os, pass);
    }

    public void saveJKS(File jks) throws Exception {
        this.saveJKS(new FileOutputStream(jks));
    }

    public void saveJKS(OutputStream os) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setKeyEntry("me", this.keypair.getPrivate(), new char[0], new Certificate[]{this.mycert, this.cacert});
        ks.store(os, new char[0]);
    }

    public void saveCertPEM(File pem) throws Exception {
        this.saveCertPEM(new FileWriter(pem));
    }

    public void saveCertPEM(Writer ww) throws Exception {
        PEMWriter w = new PEMWriter(ww);
        this.writePemHeader((Writer)w);
        w.writeObject((Object)this.mycert);
        w.close();
    }

    public void saveKeyPEM(File pem) throws Exception {
        this.saveKeyPEM(new FileWriter(pem));
    }

    public void saveKeyPEM(Writer ww) throws Exception {
        PEMWriter w = new PEMWriter(ww);
        this.writePemHeader((Writer)w);
        w.writeObject((Object)this.keypair.getPrivate());
        w.close();
    }

    private void writePemHeader(Writer w) throws IOException {
        w.write("Certificate: " + this.mycert.getSubjectDN().getName() + "\n");
        w.write("\tIssuer:" + this.mycert.getIssuerDN().getName() + "\n");
        w.write("\tSerial number:" + this.mycert.getSerialNumber().toString(16) + "\n");
        w.write("\tNot Before:" + this.mycert.getNotBefore() + "\n");
        w.write("\tNot After:" + this.mycert.getNotAfter() + "\n");
        w.write("\tOpenSSL Hash:" + this.getHash() + "\n");
        w.write("\tOpenSSL CA Hash:" + this.getCAHash() + "\n");
        w.write("\tNot After:" + this.mycert.getNotAfter() + "\n");
        w.write("\tFile written: " + new Date() + "\n");
    }

    public String getHash() {
        return CaHelper.opensslHash(this.mycert);
    }

    public String getCAHash() {
        return CaHelper.opensslHash(this.cacert);
    }

    public static IssuedCertificate generateUserCert(CertificateAuthority auth, String subject, int strength) throws Exception {
        if (strength < 1024) {
            strength = 1024;
        }
        KeyPair kp = CaHelper.generateKeyPair(strength);
        X509Certificate cert = auth.issueUser(kp.getPublic(), subject);
        return new IssuedCertificate(auth.getCACertificate(), kp, cert);
    }

    public static IssuedCertificate generateServerCert(CertificateAuthority auth, String subject, int strength) throws Exception {
        if (strength < 1024) {
            strength = 1024;
        }
        KeyPair kp = CaHelper.generateKeyPair(strength);
        X509Certificate cert = auth.issueServer(kp.getPublic(), subject);
        return new IssuedCertificate(auth.getCACertificate(), kp, cert);
    }
}

