/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keygen;

import com.peterphi.std.util.HexHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Attribute;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CaHelper {
    private static final transient Logger log = Logger.getLogger(CaHelper.class);
    public static final boolean GLOBUS_COG_HACK = true;
    public static final boolean GLOBUS_ALGORITHM_HACK = true;
    public static final DERObjectIdentifier netscapeCertType;

    private static boolean getExtendedKeyUsageCriticality() {
        return false;
    }

    private static String getSignatureAlgorithm() {
        return "MD5WITHRSA";
    }

    public static String opensslHash(X509Certificate cert) {
        try {
            return CaHelper.openssl_X509_NAME_hash(cert.getSubjectX500Principal());
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("MD5 isn't available!", e);
        }
    }

    public static String openssl_X509_NAME_hash(X500Principal p) throws NoSuchAlgorithmException {
        byte[] derEncodedSubject = p.getEncoded();
        byte[] md5 = MessageDigest.getInstance("MD5").digest(derEncodedSubject);
        byte[] result = new byte[]{md5[3], md5[2], md5[1], md5[0]};
        return HexHelper.toHex(result);
    }

    public static KeyPair generateKeyPair(int bits) throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "BC");
        keyGen.initialize(bits, new SecureRandom());
        return keyGen.generateKeyPair();
    }

    public static X509Certificate generateClientCertificate(PublicKey certificatePublicKey, PrivateKey caPrivateKey, X509Name issuer, X509Name subject) throws Exception {
        X509Certificate cert = null;
        X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
        gen.setIssuerDN(issuer);
        CaHelper.setNotBeforeNotAfter(gen, 10);
        gen.setSubjectDN(subject);
        gen.setPublicKey(certificatePublicKey);
        gen.setSignatureAlgorithm(CaHelper.getSignatureAlgorithm());
        gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        gen = CaHelper.addClientExtensions(gen);
        cert = gen.generate(caPrivateKey, "BC");
        return cert;
    }

    public static X509Certificate generateServerCertificate(PublicKey certificatePublicKey, PrivateKey caPrivateKey, X509Name issuer, X509Name subject) throws Exception {
        X509Certificate cert = null;
        X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
        gen.setIssuerDN(issuer);
        gen.setSubjectDN(subject);
        CaHelper.setNotBeforeNotAfter(gen, 10);
        gen.setPublicKey(certificatePublicKey);
        gen.setSignatureAlgorithm(CaHelper.getSignatureAlgorithm());
        gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        gen = CaHelper.addSSLServerExtensions(gen);
        cert = gen.generate(caPrivateKey, "BC");
        return cert;
    }

    private static void setNotBeforeNotAfter(X509V3CertificateGenerator gen, int validForYears) {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        now.setTimeZone(TimeZone.getTimeZone("UTC"));
        now.add(10, -48);
        gen.setNotBefore(now.getTime());
        now.add(1, validForYears);
        gen.setNotAfter(now.getTime());
    }

    public static X509Certificate generateCaCertificate(String friendlyName, KeyPair kp, BigInteger serial, X509Name issuer) throws Exception {
        return CaHelper.generateCaCertificate(friendlyName, kp, serial, issuer, issuer);
    }

    public static X509Certificate generateCaCertificate(String friendlyName, KeyPair kp, BigInteger serial, X509Name issuer, X509Name subject) throws Exception {
        X509Certificate cert = null;
        X509V3CertificateGenerator gen = new X509V3CertificateGenerator();
        gen.setIssuerDN(issuer);
        CaHelper.setNotBeforeNotAfter(gen, 20);
        gen.setSubjectDN(subject);
        gen.setPublicKey(kp.getPublic());
        gen.setSignatureAlgorithm(CaHelper.getSignatureAlgorithm());
        if (serial != null) {
            gen.setSerialNumber(serial);
        } else {
            gen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        }
        gen = CaHelper.addCaExtensions(gen, kp.getPublic());
        cert = gen.generate(kp.getPrivate(), "BC");
        cert.checkValidity();
        cert.verify(kp.getPublic(), "BC");
        if (friendlyName != null) {
            PKCS12BagAttributeCarrier bagAttr = (PKCS12BagAttributeCarrier)cert;
            bagAttr.setBagAttribute(PKCSObjectIdentifiers.pkcs_9_at_friendlyName, (DEREncodable)new DERBMPString(friendlyName));
        }
        return cert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKCS10CertificationRequest generateCertificateRequest(X509Certificate cert, PrivateKey signingKey) throws Exception {
        ASN1EncodableVector attributes = new ASN1EncodableVector();
        Set<String> nonCriticalExtensionOIDs = cert.getNonCriticalExtensionOIDs();
        for (String nceoid : nonCriticalExtensionOIDs) {
            byte[] derBytes = cert.getExtensionValue(nceoid);
            ByteArrayInputStream bis = new ByteArrayInputStream(derBytes);
            ASN1InputStream dis = new ASN1InputStream((InputStream)bis);
            try {
                DERObject derObject = dis.readObject();
                DERSet value = new DERSet((DEREncodable)derObject);
                Attribute attr = new Attribute(new DERObjectIdentifier(nceoid), (ASN1Set)value);
                attributes.add((DEREncodable)attr);
            }
            finally {
                IOUtils.closeQuietly((InputStream)dis);
            }
        }
        PKCS10CertificationRequest certificationRequest = new PKCS10CertificationRequest(CaHelper.getSignatureAlgorithm(), cert.getSubjectX500Principal(), cert.getPublicKey(), (ASN1Set)new DERSet((DEREncodableVector)attributes), signingKey);
        return certificationRequest;
    }

    private static X509V3CertificateGenerator addCaExtensions(X509V3CertificateGenerator gen, PublicKey pubKey) throws Exception {
        gen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(true));
        gen.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(182));
        gen.addExtension(X509Extensions.ExtendedKeyUsage, CaHelper.getExtendedKeyUsageCriticality(), (DEREncodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        gen.addExtension(netscapeCertType, false, (DEREncodable)new DERBitString(new byte[]{127}));
        CaHelper.addSubjectKeyIdentifier(gen, pubKey);
        CaHelper.addAuthorityKeyIdentifier(gen, pubKey);
        return gen;
    }

    private static X509V3CertificateGenerator addServerExtensions(X509V3CertificateGenerator gen, PublicKey pubKey) throws Exception {
        gen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(true));
        gen.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(176));
        gen.addExtension(X509Extensions.ExtendedKeyUsage, CaHelper.getExtendedKeyUsageCriticality(), (DEREncodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
        gen.addExtension(netscapeCertType, false, (DEREncodable)new DERBitString(new byte[]{-16}));
        CaHelper.addSubjectKeyIdentifier(gen, pubKey);
        CaHelper.addAuthorityKeyIdentifier(gen, pubKey);
        return gen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addAuthorityKeyIdentifier(X509V3CertificateGenerator gen, PublicKey pubKey) throws Exception {
        ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(pubKey.getEncoded()));
        try {
            SubjectPublicKeyInfo apki = new SubjectPublicKeyInfo((ASN1Sequence)is.readObject());
            AuthorityKeyIdentifier aki = new AuthorityKeyIdentifier(apki);
            gen.addExtension(X509Extensions.AuthorityKeyIdentifier.getId(), false, (DEREncodable)aki);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addSubjectKeyIdentifier(X509V3CertificateGenerator gen, PublicKey pubKey) throws Exception {
        ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(pubKey.getEncoded()));
        try {
            SubjectPublicKeyInfo spki = new SubjectPublicKeyInfo((ASN1Sequence)is.readObject());
            SubjectKeyIdentifier ski = new SubjectKeyIdentifier(spki);
            gen.addExtension(X509Extensions.SubjectKeyIdentifier.getId(), false, (DEREncodable)ski);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private static X509V3CertificateGenerator addSSLServerExtensions(X509V3CertificateGenerator gen) {
        gen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
        gen.addExtension(X509Extensions.KeyUsage, false, (DEREncodable)new KeyUsage(160));
        Vector<KeyPurposeId> extendedKeyUsageV = new Vector<KeyPurposeId>();
        extendedKeyUsageV.add(KeyPurposeId.id_kp_serverAuth);
        extendedKeyUsageV.add(KeyPurposeId.id_kp_clientAuth);
        gen.addExtension(X509Extensions.ExtendedKeyUsage, CaHelper.getExtendedKeyUsageCriticality(), (DEREncodable)new ExtendedKeyUsage(extendedKeyUsageV));
        return gen;
    }

    private static X509V3CertificateGenerator addClientExtensions(X509V3CertificateGenerator gen) throws Exception {
        gen.addExtension(X509Extensions.BasicConstraints, true, (DEREncodable)new BasicConstraints(false));
        gen.addExtension(X509Extensions.KeyUsage, true, (DEREncodable)new KeyUsage(180));
        gen.addExtension(X509Extensions.ExtendedKeyUsage, CaHelper.getExtendedKeyUsageCriticality(), (DEREncodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
        return gen;
    }

    public static void main(String[] args) throws Exception {
        String casubject = "C=UK, O=SOMEORG, OU=Org Unit, CN=Example Certificate Authority";
        X509Certificate cacert = null;
        PrivateKey caPrivateKey = null;
        KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
        ks.load(new FileInputStream(new File("/tmp/someorg-ca.p12")), new char[0]);
        caPrivateKey = (PrivateKey)ks.getKey("ca", new char[0]);
        cacert = (X509Certificate)ks.getCertificate("ca");
        ks = KeyStore.getInstance("PKCS12", "BC");
        ks.load(null);
        ks.setKeyEntry("ca", caPrivateKey, new char[0], new Certificate[]{cacert});
        ks.store(new FileOutputStream("/tmp/someorg-ca.p12"), new char[0]);
        ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setCertificateEntry("ca", cacert);
        ks.store(new FileOutputStream("/tmp/ca-public.jks"), new char[0]);
        PEMWriter pem = new PEMWriter((Writer)new FileWriter(new File("/tmp/d3ca.crt")));
        pem.writeObject((Object)cacert);
        pem.close();
        String user = "C=UK, O=SOMEORG, OU=Org Unit, L=SomeCompany, CN=examplehost.example.com";
        KeyPair keys = CaHelper.generateKeyPair(1024);
        X509Certificate cert = CaHelper.generateServerCertificate(keys.getPublic(), caPrivateKey, new X509Name(casubject), new X509Name(user));
        KeyStore ks2 = KeyStore.getInstance("JKS");
        ks2.load(null);
        ks2.setKeyEntry("me", keys.getPrivate(), new char[0], new Certificate[]{cert, cacert});
        ks2.store(new FileOutputStream("/tmp/host.jks"), new char[0]);
        ks2 = KeyStore.getInstance("PKCS12", "BC");
        ks2.load(null);
        ks2.setCertificateEntry("issuer", cacert);
        ks2.setCertificateEntry("me", cert);
        ks2.setKeyEntry("me", keys.getPrivate(), new char[0], new Certificate[]{cert, cacert});
        ks2.store(new FileOutputStream("/tmp/host.p12"), new char[0]);
    }

    static {
        if (Security.getProvider("BC") == null) {
            log.info((Object)"[CaHelper] Loading Bouncy Castle Provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
            log.debug((Object)"[CaHelper] Bouncy Castle Provider loaded");
        }
        netscapeCertType = new DERObjectIdentifier("2.16.840.1.113730.1.1");
    }
}

