/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest.impl;

import com.peterphi.std.crypto.digest.IDigester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class LengthDigester
implements IDigester {
    private static LengthDigester instance;

    public static LengthDigester getInstance() {
        if (instance == null) {
            instance = new LengthDigester();
        }
        return instance;
    }

    private LengthDigester() {
    }

    @Override
    public String digest(byte[] content) {
        return Integer.toString(content.length);
    }

    @Override
    public String digest(File file) throws IOException {
        return Long.toString(file.length());
    }

    @Override
    public String digest(InputStream is) throws IOException {
        return Long.toString(this.getSize(is));
    }

    @Override
    public String digest(ByteChannel channel) throws IOException {
        return Long.toString(this.getSize(channel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSize(InputStream is) throws IOException {
        long size = 0L;
        try {
            int readSize;
            byte[] buffer = new byte[4096];
            while ((readSize = is.read(buffer)) != -1) {
                size += (long)readSize;
            }
        }
        finally {
            is.close();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSize(ByteChannel channel) throws IOException {
        long size = 0L;
        try {
            ByteBuffer buffer = ByteBuffer.allocateDirect(8192);
            while (channel.read(buffer) >= 0) {
                size += (long)buffer.limit();
                buffer.clear();
            }
        }
        finally {
            channel.close();
        }
        return size;
    }
}

