/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest.impl;

import com.peterphi.std.crypto.digest.impl.AbstractDigester;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class JCEDigester
extends AbstractDigester {
    public static final JCEDigester MD2 = new JCEDigester("MD2");
    public static final JCEDigester MD5 = new JCEDigester("MD5");
    public static final JCEDigester SHA1 = new JCEDigester("SHA1");
    public static final JCEDigester SHA256 = new JCEDigester("SHA-256");
    public static final JCEDigester SHA512 = new JCEDigester("SHA-512");
    private final String algorithm;

    public JCEDigester(String algorithm) {
        this.algorithm = algorithm;
    }

    public MessageDigest newInstance() {
        try {
            return MessageDigest.getInstance(this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    @Override
    public byte[] makeDigest(byte[] content) {
        MessageDigest md = this.newInstance();
        return md.digest(content);
    }

    @Override
    public byte[] makeDigest(InputStream is) throws IOException {
        MessageDigest md = this.newInstance();
        byte[] buffer = new byte[4096];
        int readSize = 0;
        while (readSize >= 0) {
            readSize = is.read(buffer);
            if (readSize < 0) continue;
            md.update(buffer, 0, readSize);
        }
        return md.digest();
    }

    @Override
    public byte[] makeDigest(ByteChannel channel) throws IOException {
        MessageDigest md = this.newInstance();
        ByteBuffer buffer = ByteBuffer.allocate(8192);
        while (channel.read(buffer) >= 0) {
            buffer.flip();
            md.update(buffer);
            buffer.clear();
        }
        return md.digest();
    }
}

