/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest.impl;

import com.peterphi.std.crypto.digest.IDigester;
import com.peterphi.std.util.HexHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ByteChannel;

public abstract class AbstractDigester
implements IDigester {
    private final DigestEncoding encoding;

    public AbstractDigester() {
        this(DigestEncoding.HEX);
    }

    public AbstractDigester(DigestEncoding encoding) {
        this.encoding = encoding;
    }

    @Override
    public final String digest(byte[] content) {
        return this.encode(this.makeDigest(content));
    }

    @Override
    public final String digest(File file) throws IOException {
        return this.encode(this.makeDigest(file));
    }

    @Override
    public final String digest(InputStream is) throws IOException {
        return this.encode(this.makeDigest(is));
    }

    @Override
    public final String digest(ByteChannel channel) throws IOException {
        return this.encode(this.makeDigest(channel));
    }

    protected final String encode(byte[] unencoded) {
        switch (this.encoding) {
            case HEX: {
                return HexHelper.toHex(unencoded);
            }
        }
        throw new IllegalArgumentException("Illegal encoding: " + (Object)((Object)this.encoding));
    }

    public abstract byte[] makeDigest(byte[] var1);

    public byte[] makeDigest(File file) throws IOException {
        return this.makeDigest(new FileInputStream(file));
    }

    public abstract byte[] makeDigest(InputStream var1) throws IOException;

    public abstract byte[] makeDigest(ByteChannel var1) throws IOException;

    public static enum DigestEncoding {
        HEX;

    }
}

