/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest;

import com.peterphi.std.crypto.digest.DigestAlgorithm;
import com.peterphi.std.util.HexHelper;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;

public class KeyFingerprinting {
    private KeyFingerprinting() {
    }

    public static String fingerprint(KeyPair keypair) {
        return KeyFingerprinting.fingerprint(keypair.getPrivate());
    }

    public static String fingerprint(PrivateKey key) {
        return KeyFingerprinting.fingerprint(key.getEncoded());
    }

    public static String fingerprint(PublicKey key) {
        return KeyFingerprinting.fingerprint(key.getEncoded());
    }

    public static String fingerprint(byte[] derEncoded) {
        String hex = DigestAlgorithm.SHA1.getImplementation().digest(derEncoded);
        return HexHelper.toHex(':', HexHelper.fromHex(hex));
    }

    public static boolean fingerprintsEqual(String hexA, String hexB) {
        byte[] a = HexHelper.fromHex(hexA.trim());
        byte[] b = HexHelper.fromHex(hexB.trim());
        return Arrays.equals(a, b);
    }
}

