/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest;

import com.peterphi.std.crypto.digest.DigestAlgorithm;
import com.peterphi.std.crypto.digest.IDigestVerifier;
import com.peterphi.std.crypto.digest.impl.DigestVerifier;
import com.peterphi.std.crypto.digest.impl.NullVerifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ByteChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Digests
implements IDigestVerifier {
    private Map<DigestAlgorithm, String> digests = new HashMap<DigestAlgorithm, String>();
    private boolean sealed = false;

    public void addDigest(DigestAlgorithm algorithm, String digest) {
        if (this.sealed) {
            throw new IllegalStateException("Cannot add a digest to a sealed digest list");
        }
        if (digest == null || digest.isEmpty()) {
            throw new IllegalArgumentException("Digest provided for " + (Object)((Object)algorithm) + " was empty or null");
        }
        if (this.digests.containsKey((Object)algorithm)) {
            throw new IllegalStateException("Cannot replace a digest once it has been set!");
        }
        this.digests.put(algorithm, digest);
    }

    public void seal() {
        if (!this.sealed) {
            this.sealed = true;
            this.digests = Collections.unmodifiableMap(this.digests);
        }
    }

    public IDigestVerifier getVerifier() {
        return this.getVerifier(false);
    }

    public Set<DigestAlgorithm> getAlgorithms() {
        return this.digests.keySet();
    }

    public String getDigest(DigestAlgorithm algorithm) {
        return this.digests.get((Object)algorithm);
    }

    public IDigestVerifier getVerifier(boolean preferSecure) {
        DigestAlgorithm algorithm = DigestAlgorithm.getBest(preferSecure, this.digests.keySet());
        if (algorithm != null) {
            return new DigestVerifier(this.digests.get((Object)algorithm), algorithm);
        }
        return new NullVerifier(true);
    }

    @Override
    public boolean verify(byte[] content) {
        return this.getVerifier().verify(content);
    }

    @Override
    public boolean verify(File file) throws IOException {
        return this.getVerifier().verify(file);
    }

    @Override
    public boolean verify(InputStream is) throws IOException {
        return this.getVerifier().verify(is);
    }

    @Override
    public boolean verify(ByteChannel channel) throws IOException {
        return this.getVerifier().verify(channel);
    }
}

