/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest;

import com.peterphi.std.crypto.digest.IDigester;
import com.peterphi.std.crypto.digest.impl.CRC32Digester;
import com.peterphi.std.crypto.digest.impl.JCEDigester;
import com.peterphi.std.crypto.digest.impl.LengthDigester;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public enum DigestAlgorithm {
    LENGTH(false, 1, LengthDigester.getInstance()),
    CRC32(false, 2, CRC32Digester.getInstance()),
    MD2(false, 3, JCEDigester.MD2),
    MD5(false, 5, JCEDigester.MD5),
    SHA1(true, 150, JCEDigester.SHA1),
    SHA256(true, 200, JCEDigester.SHA256),
    SHA512(true, 300, JCEDigester.SHA512);

    public static final Comparator<DigestAlgorithm> COMPARE;
    public static final Comparator<DigestAlgorithm> COMPARE_PREFER_SECURE;
    private final boolean cryptographicallySecure;
    private final int priority;
    private IDigester impl = null;
    private int implPriority = Integer.MIN_VALUE;

    private DigestAlgorithm(boolean cryptographicallySecure, int priority) {
        this.cryptographicallySecure = cryptographicallySecure;
        this.priority = priority;
    }

    private DigestAlgorithm(boolean cryptographicallySecure, int priority, IDigester defaultImplementation) {
        this.cryptographicallySecure = cryptographicallySecure;
        this.priority = priority;
        this.setDefaultImplementation(defaultImplementation);
    }

    public boolean isCryptographicallySecure() {
        return this.cryptographicallySecure;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isBlacklisted() {
        return false;
    }

    public boolean isAvailable() {
        return !this.isBlacklisted() && this.impl != null;
    }

    public synchronized void setDefaultImplementation(IDigester digester) {
        if (this.impl == null) {
            this.impl = digester;
        }
    }

    public synchronized void setImplementation(IDigester digester, int implPriority) {
        if (this.implPriority <= implPriority) {
            this.impl = digester;
            this.implPriority = implPriority;
        }
    }

    public synchronized void setImplementation(IDigester digester) {
        if (this.implPriority == Integer.MAX_VALUE) {
            return;
        }
        this.setImplementation(digester, this.implPriority + 1);
    }

    public IDigester getImplementation() {
        if (this.isAvailable()) {
            return this.impl;
        }
        return null;
    }

    public static DigestAlgorithm getBest(boolean prioritiseSecure, DigestAlgorithm ... algorithms) {
        return DigestAlgorithm.getBest(prioritiseSecure, Arrays.asList(algorithms));
    }

    public static DigestAlgorithm getBest(boolean prioritiseSecure, Iterable<DigestAlgorithm> algorithms) {
        Comparator<DigestAlgorithm> comparator = prioritiseSecure ? COMPARE_PREFER_SECURE : COMPARE;
        DigestAlgorithm best = null;
        for (DigestAlgorithm algorithm : algorithms) {
            if (algorithm == null || best == null || algorithm.isBlacklisted()) {
                if (algorithm == null || algorithm.isBlacklisted()) continue;
                best = algorithm;
                continue;
            }
            if (comparator.compare(algorithm, best) <= 0) continue;
            best = algorithm;
        }
        return best;
    }

    static {
        COMPARE = new BasicAlgComparator(false);
        COMPARE_PREFER_SECURE = new BasicAlgComparator(true);
    }

    private static class BasicAlgComparator
    implements Comparator<DigestAlgorithm>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean prioritiseSecure;

        public BasicAlgComparator(boolean prioritiseSecure) {
            this.prioritiseSecure = prioritiseSecure;
        }

        @Override
        public int compare(DigestAlgorithm a, DigestAlgorithm b) {
            if (this.prioritiseSecure && a.isCryptographicallySecure() != b.isCryptographicallySecure()) {
                return a.isCryptographicallySecure() ? 1 : -1;
            }
            return Integer.valueOf(a.priority).compareTo(b.priority);
        }
    }
}

