/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.X509Name;

public class DNReformatter {
    static final DERObjectIdentifier[] ORDER_DESCENDING = new DERObjectIdentifier[]{X509Name.C, X509Name.ST, X509Name.L, X509Name.O, X509Name.OU, X509Name.CN};
    static final DERObjectIdentifier[] ORDER_ASCENDING = new DERObjectIdentifier[]{X509Name.CN, X509Name.OU, X509Name.O, X509Name.L, X509Name.ST, X509Name.C};
    public static final DNReformatter DEFAULT = new DNReformatter(ORDER_DESCENDING, ", ");
    public static final DNReformatter LDAP = new DNReformatter(ORDER_ASCENDING, ", ");
    public static final DNReformatter ACTIVE_DIRECTORY;
    public static final DNReformatter DCE;
    public static final DNReformatter GLOBUS;
    private static final DERObjectIdentifier[] ORDER_DEFAULT;
    private final DERObjectIdentifier[] order;
    private final String field_separator;
    private final String begin_dn;
    private final String end_dn;
    private final String begin_value;
    private final String end_value;

    public DNReformatter() {
        this(ORDER_DEFAULT, null, null, null, null, null);
    }

    public DNReformatter(DERObjectIdentifier[] order) {
        this(order, null, null, null, null, null);
    }

    public DNReformatter(DERObjectIdentifier[] order, String field_separator) {
        this(order, field_separator, null, null, null, null);
    }

    public DNReformatter(DERObjectIdentifier[] order, String field_separator, String begin_dn, String end_dn, String begin_value, String end_value) {
        this.order = order;
        this.field_separator = field_separator;
        this.begin_dn = begin_dn;
        this.end_dn = end_dn;
        this.begin_value = begin_value;
        this.end_value = end_value;
    }

    public DNReformatter(String[] symbols, String field_separator, String begin_dn, String end_dn, String begin_value, String end_value) {
        if (symbols == null || symbols.length == 0) {
            throw new IllegalArgumentException("You must specify a format!");
        }
        this.order = new DERObjectIdentifier[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            this.order[i] = this.oid(symbols[i]);
        }
        this.field_separator = field_separator;
        this.begin_dn = begin_dn;
        this.end_dn = end_dn;
        this.begin_value = begin_value;
        this.end_value = end_value;
    }

    public X500Principal reformat(X500Principal p) {
        return new X500Principal(this.reformatToString(p));
    }

    public X509Name reformat(X509Name dn) {
        return new X509Name(this.reformatToString(dn));
    }

    public String reformatToString(X500Principal p) {
        X509Name dn = new X509Name(p.getName("RFC2253"));
        return this.format(this.order(this.parse(dn)));
    }

    public String reformatToString(X509Name dn) {
        return this.format(this.order(this.parse(dn)));
    }

    protected List<DNInformation> order(List<DNInformation> dn) {
        ArrayList<DNInformation> ordered = new ArrayList<DNInformation>(dn.size());
        block0: for (DERObjectIdentifier oid : this.order) {
            for (DNInformation nfo : dn) {
                if (!oid.equals((Object)nfo.oid)) continue;
                ordered.add(nfo);
                continue block0;
            }
        }
        return ordered;
    }

    protected String format(List<DNInformation> dn) {
        StringBuilder sb = new StringBuilder();
        if (this.begin_dn != null) {
            sb.append(this.begin_dn);
        }
        for (int i = 0; i < dn.size(); ++i) {
            DNInformation nfo = dn.get(i);
            String symbol = this.symbol(nfo.oid);
            if (symbol == null) continue;
            if (i != 0) {
                sb.append(this.field_separator);
            }
            sb.append(symbol);
            sb.append("=");
            if (this.begin_value != null) {
                sb.append(this.begin_value);
            }
            sb.append(nfo.value);
            if (this.end_value == null) continue;
            sb.append(this.end_value);
        }
        if (this.end_dn != null) {
            sb.append(this.end_dn);
        }
        return sb.toString();
    }

    private String symbol(DERObjectIdentifier oid) {
        Object val = X509Name.DefaultSymbols.get(oid);
        if (val == null) {
            return null;
        }
        return (String)val;
    }

    private DERObjectIdentifier oid(String symbol) {
        Object val = X509Name.DefaultLookUp.get(symbol.toLowerCase());
        if (val == null) {
            return null;
        }
        return (DERObjectIdentifier)val;
    }

    protected List<DNInformation> parse(X509Name n) {
        ArrayList<DNInformation> nfo = new ArrayList<DNInformation>();
        Vector oids = n.getOIDs();
        Vector values = n.getValues();
        int size = Math.min(oids.size(), values.size());
        for (int i = 0; i < size; ++i) {
            DERObjectIdentifier oid = (DERObjectIdentifier)oids.get(i);
            if (!this.interested(oid)) continue;
            nfo.add(new DNInformation(oid, (String)values.get(i)));
        }
        return nfo;
    }

    protected boolean interested(DERObjectIdentifier oid) {
        if (oid == null) {
            return false;
        }
        for (DERObjectIdentifier id : this.order) {
            if (!id.equals((Object)oid)) continue;
            return true;
        }
        return false;
    }

    static {
        DCE = ACTIVE_DIRECTORY = new DNReformatter(ORDER_DESCENDING, "/", "/", null, null, null);
        GLOBUS = ACTIVE_DIRECTORY;
        ORDER_DEFAULT = ORDER_DESCENDING;
    }

    private static class DNInformation {
        public final DERObjectIdentifier oid;
        public final String value;

        public DNInformation(DERObjectIdentifier oid, String value) {
            this.oid = oid;
            this.value = value;
        }
    }
}

