/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Logger;

public class CertificateChainUtil {
    private static final transient Logger log = Logger.getLogger(CertificateChainUtil.class);
    public static final boolean ALLOW_LOG_SELF_SIGN_TESTS = false;

    private CertificateChainUtil() {
    }

    public static X500Principal[] getIssuerDNsFromChain(List<X509Certificate> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        X500Principal[] issuers = new X500Principal[chain.size() - 1];
        for (int i = 0; i < issuers.length; ++i) {
            X500Principal subject;
            X509Certificate certificate = chain.get(i);
            issuers[i] = subject = certificate.getSubjectX500Principal();
        }
        return issuers;
    }

    public static X500Principal getSubjectDNFromChain(List<X509Certificate> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        X509Certificate cert = chain.get(chain.size() - 1);
        return cert.getSubjectX500Principal();
    }

    public static boolean isSelfSigned(X509Certificate certificate) {
        return CertificateChainUtil.isSignedBy(certificate, certificate.getPublicKey());
    }

    public static boolean isSignedBy(X509Certificate subject, PublicKey signer) {
        try {
            subject.verify(signer);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<X509Certificate> buildChainFor(PublicKey key, Collection<X509Certificate> certs) {
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>(certs.size());
        X509Certificate subject = CertificateChainUtil.getCertificateFor(key, certs);
        if (subject == null) {
            throw new IllegalArgumentException("Cannot find X509Certificate which corresponds to " + key);
        }
        chain.add(subject);
        Certificate old = null;
        X509Certificate current = subject;
        while (!(current == null || old != null && old.equals(current) || CertificateChainUtil.isSelfSigned(current))) {
            old = current;
            if ((current = CertificateChainUtil.getIssuer(current, certs)) == null) {
                log.warn((Object)("{buildChainFor} Building chain for " + certs.size() + " cert[s] but had to stop after " + chain.size() + " because I could not find the issuer for " + ((X509Certificate)old).getSubjectX500Principal()));
                throw new IllegalArgumentException("Could not determine issuer for certificate: " + ((X509Certificate)old).getSubjectX500Principal() + ". Please ensure certificate list contains all certificates back to the CA's self-signed root!");
            }
            chain.add(current);
            if (chain.size() <= certs.size()) continue;
            log.warn((Object)("{buildChainFor} Too many certificates in chain. Chain: " + Arrays.toString(CertificateChainUtil.getPrincipals(chain)) + ", Source: " + Arrays.toString(CertificateChainUtil.getPrincipals(new ArrayList<X509Certificate>(certs)))));
            throw new IllegalStateException("Chain build failed: too many certs in chain (greater than number of input certs)! Chain: " + Arrays.toString(CertificateChainUtil.getPrincipals(chain)));
        }
        return CertificateChainUtil.normaliseChain(chain);
    }

    public static List<X509Certificate> buildChainFor(KeyPair keypair, Collection<X509Certificate> certs) {
        return CertificateChainUtil.buildChainFor(keypair.getPublic(), certs);
    }

    public static X500Principal[] getPrincipals(List<X509Certificate> chain) {
        if (chain.contains(null)) {
            throw new IllegalArgumentException("Certificate chain contains null!");
        }
        X500Principal[] array = new X500Principal[chain.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = chain.get(i).getSubjectX500Principal();
        }
        return array;
    }

    public static X509Certificate getCertificateFor(PublicKey publicKey, Collection<X509Certificate> certs) {
        for (X509Certificate cert : certs) {
            if (!cert.getPublicKey().equals(publicKey)) continue;
            return cert;
        }
        return null;
    }

    public static X509Certificate getIssuer(X509Certificate subject, Collection<X509Certificate> certs) {
        for (X509Certificate cert : certs) {
            if (!cert.getSubjectX500Principal().equals(subject.getIssuerX500Principal()) || !CertificateChainUtil.isSignedBy(subject, cert.getPublicKey())) continue;
            return cert;
        }
        return null;
    }

    public static List<X509Certificate> normaliseChain(List<X509Certificate> chain) {
        return CertificateChainUtil.toRootFirst(chain);
    }

    public static List<X509Certificate> toRootFirst(List<X509Certificate> chain) {
        List<X509Certificate> out;
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        if (!CertificateChainUtil.isSelfSigned(chain.get(0))) {
            out = new ArrayList<X509Certificate>(chain);
            Collections.reverse(out);
            if (!CertificateChainUtil.isSelfSigned(out.get(0))) {
                throw new IllegalArgumentException("Neither end of the certificate chain has a Root! " + chain);
            }
        } else {
            out = chain;
        }
        return Collections.unmodifiableList(out);
    }

    public static List<X509Certificate> toRootLast(List<X509Certificate> chain) {
        List<X509Certificate> out;
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        if (!CertificateChainUtil.isSelfSigned(chain.get(chain.size() - 1))) {
            out = new ArrayList<X509Certificate>(chain);
            Collections.reverse(out);
            if (!CertificateChainUtil.isSelfSigned(out.get(out.size() - 1))) {
                throw new IllegalArgumentException("Neither end of the certificate chain has a Root! " + chain);
            }
        } else {
            out = chain;
        }
        return Collections.unmodifiableList(out);
    }

    public static void verifyChain(List<X509Certificate> chain) {
        if (chain == null || chain.isEmpty()) {
            throw new IllegalArgumentException("Must provide a chain that is non-null and non-empty");
        }
        for (int i = 0; i < chain.size(); ++i) {
            X509Certificate certificate = chain.get(i);
            int issuerIndex = i != 0 ? i - 1 : 0;
            X509Certificate issuer = chain.get(issuerIndex);
            try {
                certificate.verify(issuer.getPublicKey());
                continue;
            }
            catch (GeneralSecurityException e) {
                String msg = "Failure verifying " + certificate + " against claimed issuer " + issuer;
                throw new IllegalArgumentException(msg + ": " + e.getMessage(), e);
            }
        }
    }
}

