/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.jaxb.JAXBSerialiser;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public class JAXBSerialiserFactory {
    private final ConcurrentHashMap<String, SoftReference<JAXBSerialiser>> cache = new ConcurrentHashMap();
    private final boolean useMoxy;

    public JAXBSerialiserFactory(boolean useMoxy) {
        this.useMoxy = useMoxy;
    }

    public JAXBSerialiser getInstance(Class<?> clazz) {
        JAXBSerialiser instance;
        String str = clazz.toString();
        SoftReference<JAXBSerialiser> ref = this.cache.get(str);
        JAXBSerialiser jAXBSerialiser = instance = ref != null ? ref.get() : null;
        if (instance == null) {
            instance = this.construct(clazz);
            this.cache.put(str, new SoftReference<JAXBSerialiser>(instance));
        }
        return instance;
    }

    public JAXBSerialiser getInstance(String contextPath) {
        JAXBSerialiser instance;
        SoftReference<JAXBSerialiser> ref = this.cache.get(contextPath);
        JAXBSerialiser jAXBSerialiser = instance = ref != null ? ref.get() : null;
        if (instance == null) {
            instance = this.construct(contextPath);
            this.cache.put(contextPath, new SoftReference<JAXBSerialiser>(instance));
        }
        return instance;
    }

    JAXBSerialiser construct(String contextPath) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(contextPath);
        }
        return JAXBSerialiser.getInstance(contextPath);
    }

    JAXBSerialiser construct(Class<?> clazz) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(clazz);
        }
        return JAXBSerialiser.getInstance(clazz);
    }
}

