/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.net.IpHelper;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.UnknownHostException;

public class InetSubnet {
    private static final long serialVersionUID = 1L;
    public static final InetSubnet IPV4_ADDRESS_SPACE = new InetSubnet(0, 0);
    public final InetAddress network;
    public final int prefix;
    private transient int maskedNetwork;
    private transient int mask;

    public InetSubnet(InterfaceAddress addr) {
        this.network = addr.getAddress();
        this.prefix = addr.getNetworkPrefixLength();
    }

    public InetSubnet(String cidr) {
        int i = cidr.indexOf(47);
        if (i != -1) {
            try {
                this.network = InetAddress.getByName(cidr.substring(0, i));
                this.prefix = Integer.parseInt(cidr.substring(i + 1));
                this.recache();
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("for InetSubnet(string) the left segment string must be a valid IP address. Illegal input was: " + cidr, e);
            }
        } else {
            throw new IllegalArgumentException("InetSubnet(string) must have a / in it. Illegal input was: " + cidr);
        }
    }

    public InetSubnet(String ip, int prefix) {
        try {
            this.network = InetAddress.getByName(ip);
            this.prefix = prefix;
            this.recache();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("for InetSubnet(string,int) the string must be a valid IP address. Illegal input was: " + ip, e);
        }
    }

    public InetSubnet(int ip, int prefix) {
        this.network = IpHelper.ntoa(ip);
        this.prefix = prefix;
    }

    public InetSubnet(InetAddress network, int prefix) {
        this.network = network;
        this.prefix = prefix;
        this.recache();
    }

    public InetSubnet(InetAddress network, InetAddress netmask) {
        this.network = network;
        this.prefix = IpHelper.netmaskToPrefix(netmask);
        this.recache();
    }

    private void recache() {
        if (this.mask == 0 && this.prefix != 0) {
            this.mask = -1 << 32 - this.prefix;
            this.maskedNetwork = IpHelper.aton(this.network) & this.mask;
        }
    }

    public String toString() {
        this.recache();
        return this.network.getHostAddress() + "/" + this.prefix;
    }

    public int hashCode() {
        return this.network.hashCode() ^ this.prefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass().equals(InetSubnet.class)) {
            InetSubnet that = (InetSubnet)o;
            return this.network.equals(that.network) && this.prefix == that.prefix;
        }
        return false;
    }

    public InetAddress getIP() {
        return this.network;
    }

    public InetAddress getNetwork() {
        this.recache();
        return IpHelper.ntoa(this.maskedNetwork);
    }

    public int getPrefix() {
        return this.prefix;
    }

    public InetAddress getNetmask() {
        this.recache();
        return IpHelper.ntoa(this.mask);
    }

    public InetSubnet canonicalise() {
        if (!this.isCanonical()) {
            return new InetSubnet(this.maskedNetwork, this.prefix);
        }
        return this;
    }

    public boolean isCanonical() {
        this.recache();
        return IpHelper.aton(this.network) == this.maskedNetwork;
    }

    public boolean isMember(int ip) {
        this.recache();
        return (ip & this.mask) == this.maskedNetwork;
    }

    public boolean isMember(String ip) {
        return this.isMember(IpHelper.aton(ip));
    }

    public boolean isMember(InetAddress ip) {
        return this.isMember(IpHelper.aton(ip));
    }

    @Deprecated
    public boolean member(int ip) {
        return this.isMember(ip);
    }

    @Deprecated
    public boolean member(String ip) {
        return this.isMember(ip);
    }

    @Deprecated
    public boolean member(InetAddress ip) {
        return this.isMember(ip);
    }

    public int getHosts() {
        return (int)Math.pow(2.0, 32 - this.prefix) - 2;
    }

    public InetAddress getHostMin() {
        this.recache();
        return IpHelper.ntoa(this.maskedNetwork + 1);
    }

    public InetAddress getHostMax() {
        this.recache();
        return IpHelper.ntoa(this.maskedNetwork + this.getHosts());
    }

    public InetAddress getBroadcast() {
        this.recache();
        return IpHelper.ntoa(this.maskedNetwork + this.getHosts() + 1);
    }

    public InetAddress getWildcardMask() {
        this.recache();
        return IpHelper.ntoa(~this.mask);
    }
}

