/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.system.exec;

import com.peterphi.std.system.exec.BaseExeced;
import com.peterphi.std.system.exec.Exec;
import java.io.IOException;
import java.io.StringWriter;
import java.util.List;

public class Execed
extends BaseExeced {
    final StringWriter stdout_content = new StringWriter();
    final StringWriter stderr_content;
    final Thread stdoutRead;
    final Thread stderrRead;

    public static Execed spawn(Exec e) throws IOException {
        ProcessBuilder pb = e.getProcessBuilder();
        return new Execed(e.cmd, pb.start(), pb.redirectErrorStream());
    }

    protected Execed(List<String> cmd, Process p, boolean combinedOutput) {
        super(cmd, p, combinedOutput);
        if (combinedOutput) {
            this.stderr_content = null;
            this.stdoutRead = this.copy(p.getInputStream(), this.stdout_content);
            this.stderrRead = null;
        } else {
            this.stderr_content = new StringWriter();
            this.stdoutRead = this.copy(p.getInputStream(), this.stdout_content);
            this.stderrRead = this.copy(p.getErrorStream(), this.stderr_content);
        }
    }

    public String getStandardOut() {
        this.stdout_content.flush();
        return this.stdout_content.getBuffer().toString();
    }

    public String getStandardError() {
        if (this.stderr_content == null) {
            return null;
        }
        return this.stderr_content.getBuffer().toString();
    }

    @Override
    public boolean isFinished() {
        return super.isFinished() && !this.stdoutRead.isAlive();
    }

    @Override
    public void discardOutput() {
        throw new RuntimeException("SimpleOutputGrabber cannot discard output!");
    }

    @Override
    public void kill() {
        this.process.destroy();
    }
}

