/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.system.exec;

import com.peterphi.std.system.exec.BaseExeced;
import com.peterphi.std.system.exec.Execed;
import com.peterphi.std.system.exec.SudoFeature;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class Exec {
    private static final transient Logger log = Logger.getLogger(Exec.class);
    private static String SUPERUSER_IDENTIFIER = UUID.randomUUID().toString();
    private boolean spawned = false;
    private String runAs = null;
    protected final List<String> cmd = new ArrayList<String>();
    private final ProcessBuilder builder = new ProcessBuilder(this.cmd);
    private final Map<String, String> environment = new HashMap<String, String>();

    public Exec(String ... command) {
        this(Arrays.asList(command));
    }

    public Exec(Iterable<String> command) {
        for (String segment : command) {
            this.cmd.add(segment);
        }
    }

    public File getWorkingDirectory() {
        String userDir;
        File builderDirectory = this.builder.directory();
        if (builderDirectory == null && (userDir = System.getProperty("user.dir")) != null) {
            builderDirectory = new File(userDir);
        }
        return builderDirectory;
    }

    public Exec setWorkingDirectory(File dir) {
        this.builder.directory(dir);
        return this;
    }

    public Exec setEnv(String key, String value) {
        this.environment.put(key, value);
        return this;
    }

    public String getEnv(String key) {
        if (this.environment.containsKey(key)) {
            return this.environment.get(key);
        }
        return this.builder.environment().get(key);
    }

    public Exec runAsSuperuser() {
        return this.runAs(SUPERUSER_IDENTIFIER);
    }

    public Exec runAs(String username) {
        if (this.isSudoCommand()) {
            throw new IllegalStateException("Will not run a sudo command as another user!");
        }
        this.runAs = username;
        return this;
    }

    public boolean getRedirectError() {
        return this.builder.redirectErrorStream();
    }

    public Exec setRedirectError(boolean value) {
        this.builder.redirectErrorStream(value);
        return this;
    }

    public BaseExeced startBasic() throws IOException {
        this.startManually();
        Process p = this.builder.start();
        return new BaseExeced(this.cmd, p, this.builder.redirectErrorStream());
    }

    public Execed start() throws IOException {
        Process p = this.getProcessBuilder().start();
        return new Execed(this.cmd, p, this.builder.redirectErrorStream());
    }

    @Deprecated
    public ProcessBuilder startManually() {
        return this.getProcessBuilder();
    }

    public ProcessBuilder getProcessBuilder() {
        if (this.spawned) {
            return this.builder;
        }
        if (this.runAs != null) {
            String noninteractive;
            String command = this.cmd.get(0);
            if (command.charAt(0) == '-' && !SudoFeature.hasArgumentsEnd()) {
                throw new IllegalArgumentException("Command to runAs starts with - but this version of sudo does not support the -- argument end token: this command cannot, therefore, be executed securely. Command was: '" + command + "'");
            }
            if (this.environment.size() > 0) {
                for (String key : this.environment.keySet()) {
                    String value = this.environment.get(key);
                    String var = key + "=" + value;
                    this.addToCmd(0, var);
                }
                this.addToCmd(0, "env");
            }
            if (SudoFeature.hasArgumentsEnd()) {
                this.addToCmd(0, "--");
            }
            String string = noninteractive = SudoFeature.hasNonInteractive() ? "-n" : null;
            if (this.runAs.equals(SUPERUSER_IDENTIFIER)) {
                this.addToCmd(0, "sudo", noninteractive);
            } else {
                this.addToCmd(0, "sudo", noninteractive, "-u", this.runAs);
            }
        } else {
            this.builder.environment().putAll(this.environment);
        }
        this.spawned = true;
        if (log.isInfoEnabled()) {
            log.info((Object)("ProcessBuilder created for command: " + Exec.join(" ", this.cmd)));
        }
        return this.builder;
    }

    protected static String join(String with, String ... strings) {
        return Exec.join(with, Arrays.asList(strings));
    }

    protected static String join(String with, List<String> strings) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (String str : strings) {
            if (!isFirst) {
                sb.append(with);
            } else {
                isFirst = false;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    private void addToCmd(int position, String ... args) {
        if (args != null) {
            for (int i = args.length - 1; i != -1; --i) {
                if (args[i] == null) continue;
                this.cmd.add(position, args[i]);
            }
        }
    }

    boolean isSudoCommand() {
        return this.cmd.get(0).equals("sudo");
    }

    public static Execed rootUtility(String ... command) throws IOException {
        return Exec.rootUtility(Arrays.asList(command));
    }

    public static Execed rootUtility(Iterable<String> command) throws IOException {
        Exec e = new Exec(command);
        e.runAsSuperuser();
        e.setRedirectError(true);
        return e.start();
    }

    public static Execed utility(String ... command) throws IOException {
        return Exec.utilityAs(null, command);
    }

    public static Execed utility(Iterable<String> command) throws IOException {
        return Exec.utilityAs(null, command);
    }

    public static Execed utilityAs(String as, String ... command) throws IOException {
        return Exec.utilityAs(as, Arrays.asList(command));
    }

    public static Execed utilityAs(String as, Iterable<String> command) throws IOException {
        Exec e = new Exec(command);
        if (as != null) {
            e.runAs(as);
        }
        e.setRedirectError(true);
        return e.start();
    }

    public static Execed appAs(String as, String ... command) throws IOException {
        return Exec.appAs(as, Arrays.asList(command));
    }

    public static Execed appAs(String as, Iterable<String> command) throws IOException {
        Exec e = new Exec(command);
        if (as != null) {
            e.runAs(as);
        }
        e.setRedirectError(false);
        return e.start();
    }
}

