/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.xstream;

import com.peterphi.std.types.BooleanMessage;
import com.peterphi.std.xstream.XSHelper;
import com.peterphi.std.xstream.serialisers.InetAddressConverter;
import com.peterphi.std.xstream.serialisers.URIConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class XStreamHelper {
    private static XSHelper _xs;
    private static boolean cacheXStream;
    private static boolean registerStandardTypeConverters;
    private static boolean noObjectGraph;

    private XStreamHelper() {
    }

    public static synchronized void setNoObjectGraph(boolean val) {
        if (cacheXStream && val != noObjectGraph) {
            _xs = null;
        }
        noObjectGraph = val;
    }

    public static synchronized boolean getNoObjectGraph() {
        return noObjectGraph;
    }

    public static synchronized void setRegisterStandardTypeConverters(boolean val) {
        if (registerStandardTypeConverters != val && cacheXStream) {
            _xs = null;
        }
        registerStandardTypeConverters = val;
    }

    public static synchronized boolean getRegisterStandardTypeConverters() {
        return registerStandardTypeConverters;
    }

    public static synchronized void setCacheXstream(boolean val) {
        if (val != cacheXStream) {
            _xs = null;
        }
        cacheXStream = val;
    }

    public static synchronized boolean getCacheXstream() {
        return cacheXStream;
    }

    public static synchronized void setXs(XSHelper xs) {
        if (!cacheXStream) {
            throw new Error("Can only set the default xstream object when caching is enabled");
        }
        _xs = xs;
    }

    private static synchronized XSHelper getXs() {
        return XStreamHelper.getXs(cacheXStream);
    }

    private static synchronized XSHelper getXs(boolean cached) {
        XSHelper xs;
        XSHelper xSHelper = xs = cached ? _xs : null;
        if (xs == null) {
            xs = XSHelper.create();
            if (registerStandardTypeConverters) {
                xs.registerConverter((SingleValueConverter)new URIConverter());
                xs.registerConverter((SingleValueConverter)new InetAddressConverter());
            }
            xs.setNoObjectGraph(noObjectGraph);
            if (cached) {
                _xs = xs;
            }
        }
        return xs;
    }

    public static synchronized XSHelper create() {
        return XStreamHelper.getXs(false);
    }

    public static synchronized void useAttributeFor(Class<? extends Object> definedIn, String fieldName) {
        if (!cacheXStream) {
            throw new Error("Can only set attributes for fields when xstream caching is enabled");
        }
        XStreamHelper.getXs().useAttributeFor(definedIn, fieldName);
    }

    public static synchronized void addAlias(String alias, Class aliasedClass) {
        if (!cacheXStream) {
            throw new Error("Can only add aliases when xstream caching is enabled");
        }
        XStreamHelper.getXs().alias(alias, aliasedClass);
    }

    public static synchronized void addAlias(String alias, Class aliasedClass, Class defaultImplementation) {
        if (!cacheXStream) {
            throw new Error("Can only add aliases when xstream caching is enabled");
        }
        XStreamHelper.getXs().alias(alias, aliasedClass, defaultImplementation);
    }

    public static synchronized void registerConverter(Converter converter) {
        if (!cacheXStream) {
            throw new Error("Can only add converters when xstream caching is enabled");
        }
        XStreamHelper.getXs().registerConverter(converter);
    }

    public static String serialise(Object o) {
        return XStreamHelper.getXs().serialise(o);
    }

    public static BooleanMessage serialise(File f, Object o) {
        return XStreamHelper.getXs().serialise(f, o);
    }

    public static BooleanMessage serialise(OutputStream os, Object o) {
        return XStreamHelper.getXs().serialise(os, o);
    }

    public static Object deserialise(File f) {
        return XStreamHelper.getXs().deserialise(f);
    }

    public static Object deserialise(String xml) {
        return XStreamHelper.getXs().deserialise(xml);
    }

    public static Object deserialise(InputStream stream) {
        return XStreamHelper.getXs().deserialise(stream);
    }

    public static Class typeOf(XStream xs, String s) {
        Object o = xs.fromXML(s);
        if (o == null) {
            return null;
        }
        return o.getClass();
    }

    public static <T> T clone(T obj) {
        return XStreamHelper.getXs().clone(obj);
    }

    static {
        cacheXStream = true;
        registerStandardTypeConverters = true;
        noObjectGraph = true;
    }
}

