/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.types;

import com.peterphi.std.types.ResamplingException;
import com.peterphi.std.types.Timebase;
import com.peterphi.std.types.Timecode;

public class SampleCount {
    private final Timebase rate;
    private final long samples;

    public SampleCount(long samples, Timebase rate) {
        if (rate == null) {
            throw new IllegalArgumentException("Must specify a rate!");
        }
        this.samples = samples;
        this.rate = rate;
    }

    public SampleCount resample(Timebase newRate) {
        if (!this.rate.equals(newRate)) {
            long newSamples = this.getSamples(newRate);
            return new SampleCount(newSamples, newRate);
        }
        return this;
    }

    public SampleCount add(SampleCount that) {
        long thatSamples = that.getSamples(this.rate);
        if (thatSamples != 0L) {
            return new SampleCount(this.samples + thatSamples, this.rate);
        }
        return this;
    }

    public SampleCount addPrecise(SampleCount that) throws ResamplingException {
        long thatSamples = that.getSamplesPrecise(this.rate);
        if (thatSamples != 0L) {
            return new SampleCount(this.samples + thatSamples, this.rate);
        }
        return this;
    }

    public SampleCount subtract(SampleCount that) {
        long thatSamples = that.getSamples(this.rate);
        if (thatSamples != 0L) {
            return new SampleCount(this.samples - thatSamples, this.rate);
        }
        return this;
    }

    public SampleCount subtractPrecise(SampleCount that) throws ResamplingException {
        long thatSamples = that.getSamplesPrecise(this.rate);
        if (thatSamples != 0L) {
            return new SampleCount(this.samples - thatSamples, this.rate);
        }
        return this;
    }

    public Timebase getRate() {
        return this.rate;
    }

    public long getSamples() {
        return this.samples;
    }

    public long getSamples(Timebase newRate) {
        return newRate.resample(this.samples, this.rate);
    }

    public long getSamplesPrecise(Timebase newRate) throws ResamplingException {
        return newRate.resamplePrecise(this.samples, this.rate);
    }

    public String toString() {
        return this.samples + "@" + this.rate.toEncodedString();
    }

    public String toFfmpegString() {
        return Timecode.getInstance(this).toFfmpegString();
    }

    @Deprecated
    public static SampleCount parseVidispine(String countAndRate) {
        return SampleCount.valueOf(countAndRate);
    }

    public static SampleCount valueOf(String countAndRate) {
        if (countAndRate == null) {
            return null;
        }
        String[] parts = countAndRate.split("@");
        if (parts.length == 2) {
            long samples = Long.parseLong(parts[0]);
            Timebase timebase = Timebase.getInstance(parts[1]);
            return new SampleCount(samples, timebase);
        }
        throw new IllegalArgumentException("Invalid Vidispine sample count: " + countAndRate + " expected a single @ separating sample count and rate.");
    }

    public static SampleCount seconds(Timebase rate, int seconds) {
        double samples = rate.getSamplesPerSecond() * (double)seconds;
        return new SampleCount((long)samples, rate);
    }

    @Deprecated
    public String toVidispineString() {
        return this.toString();
    }

    public double getSeconds() {
        return Timebase.HZ_1.resample((double)this.samples, this.rate);
    }

    public int hashCode() {
        return (int)(this.samples ^ this.samples >>> 32) ^ this.rate.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        SampleCount that = (SampleCount)o;
        if (this.getSamples() != that.getSamples()) {
            return false;
        }
        return this.getRate().equals(that.getRate());
    }
}

