/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.auth.yubikey;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;

public class YubicoClient {
    static final String YUBICO_AUTH_SRV_URL = "http://api.yubico.com/wsapi/verify?id=";
    private int _clientId;
    private static transient YubicoClient client;

    public static YubicoClient getInstance() {
        if (client == null) {
            client = new YubicoClient();
        }
        return client;
    }

    public YubicoClient() {
        this(2349);
    }

    public YubicoClient(int initId) {
        this._clientId = initId;
    }

    public int getId() {
        return this._clientId;
    }

    public boolean verify(String otp) {
        boolean result = false;
        try {
            String inputLine;
            URL srv = new URL(YUBICO_AUTH_SRV_URL + this._clientId + "&otp=" + otp);
            URLConnection conn = srv.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                if (!inputLine.startsWith("status=") || !inputLine.equals("status=OK")) continue;
                result = true;
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error! " + e.getMessage());
        }
        return result;
    }
}

