/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util.jaxb;

import com.peterphi.std.util.jaxb.JAXBSerialiser;
import java.util.concurrent.ConcurrentHashMap;

public class JAXBSerialiserFactory {
    private final ConcurrentHashMap<String, JAXBSerialiser> cache = new ConcurrentHashMap();
    private final boolean useMoxy;

    public JAXBSerialiserFactory(boolean useMoxy) {
        this.useMoxy = useMoxy;
    }

    public JAXBSerialiser getInstance(Class<?> clazz) {
        String str = clazz.toString();
        JAXBSerialiser instance = this.cache.get(str);
        if (instance == null) {
            instance = this.construct(clazz);
            this.cache.put(str, instance);
        }
        return instance;
    }

    public JAXBSerialiser getInstance(String contextPath) {
        JAXBSerialiser instance = this.cache.get(contextPath);
        if (instance == null) {
            instance = this.construct(contextPath);
            this.cache.put(contextPath, instance);
        }
        return instance;
    }

    JAXBSerialiser construct(String contextPath) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(contextPath);
        }
        return JAXBSerialiser.getInstance(contextPath);
    }

    JAXBSerialiser construct(Class<?> clazz) {
        if (this.useMoxy) {
            return JAXBSerialiser.getMoxy(clazz);
        }
        return JAXBSerialiser.getInstance(clazz);
    }
}

