/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io;

import com.peterphi.std.io.properties.IMergeConflictResolver;
import com.peterphi.std.util.Base64;
import com.peterphi.std.util.HexHelper;
import com.peterphi.std.util.ListUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class PropertyFile {
    private static final transient Logger log = Logger.getLogger(PropertyFile.class);
    private static final String NEWLINE = "\n";
    private static final String COMMENT_INST = "#-- ";
    private static final char COMMENT_CHAR = '#';
    protected File f;
    protected boolean readOnly = false;
    protected boolean caseSensitive = true;
    protected boolean forceNameValueDelimiterWhitespace = false;
    protected List<Entry> entries = new ArrayList<Entry>();
    protected Map<String, NameValuePair> vars = new HashMap<String, NameValuePair>();
    protected boolean dirty = false;

    public static PropertyFile find() {
        return PropertyFile.find("service.properties");
    }

    public static PropertyFile find(String fileName) {
        try {
            if (fileName.startsWith("/")) {
                return PropertyFile.readOnly(new File(fileName));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Property file could not be loaded: " + fileName);
        }
        return PropertyFile.find(PropertyFile.class.getClassLoader(), fileName);
    }

    public static PropertyFile find(ClassLoader classloader, String ... fileNames) {
        URL resolvedResource = null;
        String resolvedFile = null;
        for (String fileName : fileNames) {
            if (fileName.charAt(0) == '/') {
                File file = new File(fileName);
                if (!file.exists()) continue;
                try {
                    return PropertyFile.readOnly(file);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Error loading property file: " + fileName + ". Error: " + e.getMessage(), e);
                }
            }
            URL resource = classloader.getResource(fileName);
            if (resource == null) continue;
            resolvedFile = fileName;
            resolvedResource = resource;
            break;
        }
        if (resolvedFile == null) {
            if (fileNames.length == 1) {
                throw new IllegalArgumentException("Error finding property file in classpath: " + fileNames[0]);
            }
            throw new IllegalArgumentException("Error finding property files in classpath: " + Arrays.asList(fileNames));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("[PropertyFile] {find} Loading properties from " + resolvedFile));
        }
        return PropertyFile.openResource(classloader, resolvedResource, resolvedFile);
    }

    public static PropertyFile openResource(ClassLoader classloader, URL resource, String fileName) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("[PropertyFile] {find} Resource search results: " + resource));
            }
            if (resource.getProtocol().equalsIgnoreCase("file")) {
                String fileComponent = resource.getFile();
                String filePath = URLDecoder.decode(fileComponent, "UTF8");
                File file = new File(filePath);
                return PropertyFile.readOnly(file);
            }
            log.trace((Object)"{openResource} Falling back to opening resource as stream: PropertyFile filename will remain unknown");
            InputStream is = classloader.getResourceAsStream(fileName);
            PropertyFile props = new PropertyFile();
            props.load(is);
            return props;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error finding/loading property file: " + fileName + ". Error: " + e.getMessage(), e);
        }
    }

    public static PropertyFile[] findAll(String name) {
        return PropertyFile.findAll(PropertyFile.class.getClassLoader(), name);
    }

    public static PropertyFile[] findAll(ClassLoader loader, String name) {
        try {
            Enumeration<URL> urls = loader.getResources(name);
            ArrayList<PropertyFile> files = new ArrayList<PropertyFile>();
            for (URL url : ListUtility.iterate(urls)) {
                InputStream is = null;
                try {
                    is = url.openStream();
                    PropertyFile file = new PropertyFile(is);
                    files.add(file);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading properties from " + url + " for name: " + name + ": " + e.getMessage(), e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            return files.toArray(new PropertyFile[files.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties for name: " + name + ": " + e.getMessage(), e);
        }
    }

    public PropertyFile(File fileName) throws IOException {
        this(fileName, true);
    }

    public PropertyFile(File fileName, boolean caseSensitive) throws IOException {
        this.setFile(fileName);
        this.caseSensitive = caseSensitive;
        this.load();
    }

    public PropertyFile() {
    }

    public PropertyFile(InputStream is, boolean caseSensitive) throws IOException {
        this.caseSensitive = caseSensitive;
        this.load(is);
    }

    public PropertyFile(Reader r) throws IOException {
        this(r, true);
    }

    public PropertyFile(Reader r, boolean caseSensitive) throws IOException {
        this.caseSensitive = caseSensitive;
        this.load(r);
    }

    public PropertyFile(InputStream is) throws IOException {
        this(is, true);
    }

    public PropertyFile(Properties p) {
        this(p, false);
    }

    public PropertyFile(Properties p, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.load(p);
    }

    public Properties toProperties() {
        Properties p = new Properties();
        for (NameValuePair nvp : this.vars.values()) {
            p.put(nvp.name, nvp.value);
        }
        return p;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public File getFile() {
        return this.f;
    }

    public void setFile(File file) {
        this.f = file;
    }

    public void setForceNameValueDelimiterWhitespace(boolean value) {
        this.forceNameValueDelimiterWhitespace = value;
    }

    public boolean getForceNameValueDelimiterWhitespace() {
        return this.forceNameValueDelimiterWhitespace;
    }

    public void load() throws IOException {
        assert (this.f != null);
        this.load(this.f);
    }

    public void load(Properties p) {
        try {
            StringWriter sw = new StringWriter();
            p.store(sw, null);
            StringBuffer sb = sw.getBuffer();
            StringReader sr = new StringReader(sb.toString());
            this.load(sr);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void load(File file) throws IOException {
        assert (file != null);
        this.load(new FileReader(file));
    }

    public void load(InputStream is) throws IOException {
        this.load(new InputStreamReader(is));
    }

    public void save() throws IOException {
        this.save(this.f, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File f, String comment) throws IOException {
        assert (f != null);
        try (FileWriter fw = new FileWriter(f);){
            this.save(comment, fw);
        }
    }

    public void save(OutputStream os) throws IOException {
        this.save(null, new OutputStreamWriter(os));
    }

    public void save(String comment) throws IOException {
        this.save(this.f, comment);
    }

    public void save(String comment, OutputStream os) throws IOException {
        this.save(comment, new OutputStreamWriter(os));
    }

    public void merge(PropertyFile other) {
        this.merge(other, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(PropertyFile other, IMergeConflictResolver conflictResolver) {
        this.hook_merge_begin();
        try {
            for (String varName : other.keySet()) {
                String varVal = other._get(varName, null);
                if (varVal == null) continue;
                if (conflictResolver != null && this._contains(varName)) {
                    varVal = conflictResolver.resolveConflict(varName, this._get(varName, null), varVal);
                }
                this._set(varName, varVal);
            }
        }
        finally {
            this.hook_merge_complete();
        }
    }

    public void merge(Properties other) {
        this.merge(other, null);
    }

    public void merge(Properties other, IMergeConflictResolver conflictResolver) {
        PropertyFile otherAsPropFile = new PropertyFile(other);
        this.merge(otherAsPropFile, conflictResolver);
    }

    public void makeReadOnly() {
        this.readOnly = true;
    }

    public boolean containsKey(String name) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[PropertyFile] {containsKey} key=" + name));
        }
        return this._contains(name);
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[PropertyFile] {get} key=" + name + "; default=" + defaultValue + "; storedValue=" + this._get_core(name, null)));
        }
        return this._get(name, defaultValue);
    }

    public InetAddress getIP(String name, InetAddress defaultValue) {
        String value = this.get(name);
        if (value != null) {
            if ((value = value.trim()).isEmpty()) {
                throw new IllegalArgumentException("Missing value for IP address field " + name + ": contents appears to be an empty string (or just whitespace?)");
            }
            try {
                return InetAddress.getByName(value);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Error parsing IP: " + e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    public int get(String name, int defaultValue) {
        return Integer.parseInt(this.get(name, Integer.toString(defaultValue)).trim());
    }

    public long get(String name, long defaultValue) {
        return Long.parseLong(this.get(name, Long.toString(defaultValue)).trim());
    }

    public boolean get(String name, boolean defaultValue) {
        return Boolean.parseBoolean(this.get(name, Boolean.toString(defaultValue)).trim());
    }

    public int getInteger(String name, int defaultValue) {
        return Integer.parseInt(this.get(name, Integer.toString(defaultValue)).trim());
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        return PropertyFile.parseBoolean(this.get(name, Boolean.toString(defaultValue)).trim());
    }

    private static boolean parseBoolean(String value) {
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("no") || value.equalsIgnoreCase("off")) {
            return false;
        }
        throw new IllegalArgumentException("Cannot parse to a boolean value: " + value);
    }

    public long getLong(String name, long defaultValue) {
        return Long.parseLong(this.get(name, Long.toString(defaultValue)).trim());
    }

    public URI getURI(String name, String defaultValue) {
        String uri = this.get(name, null);
        if (uri == null && defaultValue == null) {
            return null;
        }
        if (uri == null) {
            uri = defaultValue;
        }
        try {
            return new URI(uri.trim());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Illegal URI: " + uri, e);
        }
    }

    public Class<?> getClass(String name, Class<?> defaultValue) {
        String className = this.get(name, null);
        if (className == null) {
            return defaultValue;
        }
        try {
            return Class.forName(className.trim());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("ClassNotFoundException caught: " + className, e);
        }
    }

    public byte[] getBase64(String name) {
        String encoded = this.get(name);
        try {
            if (encoded == null) {
                return null;
            }
            return Base64.decode(encoded.trim());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not decode base64: " + encoded);
        }
    }

    public byte[] getBase64(String name, byte[] defaultValue) {
        byte[] value = this.getBase64(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public byte[] getHex(String name) {
        String value = this.get(name, null);
        if (value == null) {
            return null;
        }
        while (value.indexOf(58) != -1) {
            value = value.replace(":", "");
        }
        return HexHelper.fromHex(value.trim());
    }

    public String set(String name, String value) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[PropertyFile] {set} key=" + name + "; value=" + value));
        }
        return this._set(name, value);
    }

    public String setBase64(String name, byte[] value) {
        String encoded = Base64.encodeBytes(value);
        return this.set(name, encoded);
    }

    public String setHex(String name, byte[] value) {
        return this.set(name, HexHelper.toHex(value));
    }

    public String set(String name, long value) {
        return this.set(name, Long.toString(value));
    }

    public String set(String name, int value) {
        return this.set(name, Integer.toString(value));
    }

    public void remove(String name) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("[PropertyFile] {remove} key=" + name));
        }
        this._rm(name);
    }

    public void clear() {
        this._clear();
    }

    public Set<String> keySet() {
        return this.vars.keySet();
    }

    public Iterator<String> keyIterator() {
        return this.vars.keySet().iterator();
    }

    public int getLineCount() {
        return this.entries.size();
    }

    public int getVariableCount() {
        return this.vars.size();
    }

    protected void hook_changed(String name, String oldValue, String newValue) {
        this.dirty = true;
    }

    protected void hook_added(String name, String newValue) {
        this.dirty = true;
    }

    protected void hook_removed(String name) {
        this.dirty = true;
    }

    protected void hook_cleared() {
        this.dirty = true;
    }

    protected void hook_merge_begin() {
    }

    protected void hook_merge_complete() {
    }

    protected void hook_loaded() {
        this.dirty = false;
    }

    protected void hook_saved() {
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Reader r) throws IOException {
        this.entries.clear();
        this.vars.clear();
        try (BufferedReader in = null;){
            in = new BufferedReader(r);
            String line = in.readLine();
            while (line != null) {
                if (line.length() == 0) {
                    this.entries.add(new BlankLine());
                } else {
                    char c = line.charAt(0);
                    if (c == '#') {
                        if (!line.startsWith(COMMENT_INST)) {
                            this.entries.add(new Comment(line.substring(1)));
                        }
                    } else if (c == ' ') {
                        this.entries.add(new BlankLine());
                    } else {
                        int equalsIndex = line.indexOf(61);
                        if (equalsIndex != -1) {
                            String name = line.substring(0, equalsIndex).trim();
                            String value = line.substring(equalsIndex + 1);
                            NameValuePair nvp = new NameValuePair(name, value);
                            if (this.vars.containsKey(nvp.name)) {
                                log.warn((Object)"[PropertyFile] {load} duplicate entry: overwriting previous value");
                            }
                            this.entries.add(nvp);
                            this.vars.put(this.caseSensitive ? nvp.name : nvp.name.toLowerCase(), nvp);
                        } else {
                            log.error((Object)("Malformed line in property file: " + line));
                        }
                    }
                }
                line = in.readLine();
            }
            this.hook_loaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String comment, Writer w) throws IOException {
        try {
            if (comment != null) {
                w.append(COMMENT_INST);
                w.append(comment);
                w.append(NEWLINE);
                w.append(COMMENT_INST);
                w.append("at ");
                w.append(Calendar.getInstance().getTime().toString());
                w.append(NEWLINE);
            }
            int sz = this.entries.size();
            for (int i = 0; i < sz; ++i) {
                this.entries.get(i).append(w, this);
            }
            this.hook_saved();
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    protected void _clear() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"[PropertyFile] {_clear}");
        }
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection");
        }
        this.entries.clear();
        this.vars.clear();
        this.hook_cleared();
    }

    protected String _set(String name, String value) {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify a read-only collection");
        }
        assert (name != null);
        name = name.trim();
        NameValuePair nvp = this.vars.get(this.caseSensitive ? name : name.toLowerCase());
        if (nvp != null) {
            String oldValue = nvp.value;
            nvp.value = value;
            this.hook_changed(name, oldValue, value);
            return oldValue;
        }
        nvp = new NameValuePair(name, value);
        this.entries.add(nvp);
        this.vars.put(this.caseSensitive ? name : name.toLowerCase(), nvp);
        this.hook_added(name, value);
        return null;
    }

    protected String _get(String name, String defaultValue) {
        assert (name != null);
        name = name.trim();
        return this._get_core(name, defaultValue);
    }

    protected String _get_core(String name, String defaultValue) {
        NameValuePair nvp = this.vars.get(this.caseSensitive ? name : name.toLowerCase());
        if (nvp == null) {
            return defaultValue;
        }
        if (this.forceNameValueDelimiterWhitespace && nvp.value.length() > 0 && nvp.value.charAt(0) == ' ') {
            return nvp.value.substring(1);
        }
        return nvp.value;
    }

    protected boolean _contains(String name) {
        assert (name != null);
        name = name.trim();
        return this.vars.containsKey(this.caseSensitive ? name : name.toLowerCase());
    }

    protected void _rm(String name) {
        assert (name != null);
        name = name.trim();
        NameValuePair nvp = this.vars.get(this.caseSensitive ? name : name.toLowerCase());
        this.vars.remove(this.caseSensitive ? name : name.toLowerCase());
        this.entries.remove(nvp);
        this.hook_removed(name);
    }

    public static PropertyFile readOnlyUnion(File ... filenames) throws IOException {
        PropertyFile props = new PropertyFile();
        for (File f : filenames) {
            if (f == null || !f.exists()) continue;
            props.merge(new PropertyFile(f));
        }
        props.readOnly = true;
        return props;
    }

    public static PropertyFile readOnlyUnion(PropertyFile ... files) {
        PropertyFile props = new PropertyFile();
        for (PropertyFile file : files) {
            if (file == null) continue;
            props.merge(file);
        }
        props.makeReadOnly();
        return props;
    }

    public static PropertyFile readOnly(File filename) throws IOException {
        PropertyFile props = new PropertyFile(filename);
        props.readOnly = true;
        return props;
    }

    protected class NameValuePair
    extends Entry {
        private boolean unusualName;
        public String name;
        public String value;

        private void checkName() {
            this.unusualName = this.name.contains("=");
        }

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
            this.checkName();
        }

        @Override
        public void append(Writer w, PropertyFile p) throws IOException {
            if (!this.unusualName) {
                w.append(this.name);
            } else {
                log.warn((Object)"[NameValuePair] {append} name needs escapingbut this implementation doesn't escape");
                w.append(this.name);
            }
            if (PropertyFile.this.forceNameValueDelimiterWhitespace && !this.name.endsWith(" ")) {
                w.append(" ");
            }
            w.append("=");
            if (PropertyFile.this.forceNameValueDelimiterWhitespace && !this.value.startsWith(" ")) {
                w.append(" ");
            }
            w.append(this.value);
            w.append(PropertyFile.NEWLINE);
        }
    }

    protected class Comment
    extends Entry {
        public String data;

        public Comment(String data) {
            this.data = data;
        }

        @Override
        public void append(Writer w, PropertyFile p) throws IOException {
            w.append('#');
            w.append(this.data);
            w.append(PropertyFile.NEWLINE);
        }
    }

    protected class BlankLine
    extends Entry {
        protected BlankLine() {
        }

        @Override
        public void append(Writer w, PropertyFile p) throws IOException {
            w.append(PropertyFile.NEWLINE);
        }
    }

    protected abstract class Entry {
        protected Entry() {
        }

        public abstract void append(Writer var1, PropertyFile var2) throws IOException;
    }
}

