/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.io;

import com.peterphi.std.io.ChmodBit;
import com.peterphi.std.io.StringBuilderReader;
import com.peterphi.std.system.exec.Exec;
import com.peterphi.std.system.exec.Execed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileHelper {
    private static final transient Logger log = Logger.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static File createTempFile(String prefix, String suffix) {
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            if (tempFile.exists() && !tempFile.delete()) {
                throw new RuntimeException("Could not delete new temp file: " + tempFile);
            }
            return tempFile;
        }
        catch (IOException e) {
            log.error((Object)("[FileHelper] {createTempFile} Error creating temp file: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static String enforceSafeFilename(String filename) {
        int safeChar = 46;
        char[] chars = filename.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (FileHelper.isSafeFilenameCharacter(chars[i])) continue;
            chars[i] = 46;
        }
        return String.valueOf(chars);
    }

    private static boolean isSafeFilenameCharacter(char c) {
        if (Character.isLetterOrDigit(c)) {
            return true;
        }
        return c == '-' || c == '_' || c == '.';
    }

    public static boolean isAbsoluteFile(File f) {
        try {
            return f.isAbsolute();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isAbsoluteFile(String filename) {
        return FileHelper.isAbsoluteFile(new File(filename));
    }

    public static boolean isAncestor(File root, File f) {
        while (f != null && !f.equals(root)) {
            f = f.getParentFile();
        }
        return f != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean couldWrite(File f) {
        if (f == null) {
            throw new IllegalArgumentException("Must specify a non-null file!");
        }
        if (f.exists()) return f.canWrite();
        try {
            if (!f.getParentFile().exists()) {
                log.info((Object)"{couldWrite} Could not determine if the file is writable because the parent directory did not exist");
                return false;
            }
            try {
                FileHelper.write(f, "");
                boolean bl = f.exists();
                return bl;
            }
            finally {
                if (!f.delete()) {
                    log.warn((Object)("Could not delete file once written: " + f));
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)("{couldWrite} Error while testing: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static void copy(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("Cannot copy from non-existant source " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("[FileHelper] {copy} Copying " + src + " to " + dest));
        }
        if (src.isDirectory()) {
            FileUtils.copyDirectory((File)src, (File)dest);
        } else {
            if (dest.exists()) {
                FileHelper.delete(dest);
            }
            FileUtils.copyFile((File)src, (File)dest);
            if (log.isTraceEnabled()) {
                if (src.length() != dest.length()) {
                    log.trace((Object)"[FileHelper] {copy} src and dest have different sizes at the end of the copy process!");
                } else {
                    log.trace((Object)"[FileHelper] {copy} Success: src and dest are identically sized");
                }
            }
        }
    }

    public static void move(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException("Cannot copy from non-existant source " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("[FileHelper] {move} Moving " + src + " to " + dest));
        }
        if (!src.renameTo(dest)) {
            if (src.isDirectory()) {
                FileUtils.copyDirectory((File)src, (File)dest);
                FileUtils.deleteDirectory((File)src);
            } else {
                FileUtils.copyFile((File)src, (File)dest);
                src.delete();
            }
        }
    }

    public static boolean trySymlink(File from, File to) {
        try {
            FileHelper.symlink(from, to);
            return true;
        }
        catch (IOException e) {
            log.error((Object)("[FileHelper] {trySymlink} Failure: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static void symlink(File from, File to) throws IOException {
        try {
            if (!from.exists()) {
                throw new FileNotFoundException("Symbolic link source does not exist: " + from);
            }
            if (to.exists() && !to.delete()) {
                throw new IOException("Could not delete file: " + to);
            }
            int returnCode = Exec.utilityAs(null, "ln", "-s", from.toString(), to.toString()).waitForExit();
            if (returnCode != 0) {
                throw new IOException("ln command returned nonzero return code: " + returnCode);
            }
            if (!to.exists()) {
                throw new IOException("Symbolic link does not exist (but ln claimed successful execution)");
            }
            if (!to.getCanonicalFile().equals(from.getCanonicalFile())) {
                throw new IOException("Link points to the wrong place (to.getCanonicalFile() != from.getCanonicalFile()");
            }
        }
        catch (IOException e) {
            log.error((Object)("[FileHelper] {symlink} Failure: " + e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    @Deprecated
    public static boolean safeMove(File src, File dest) throws SecurityException {
        assert (src.exists());
        boolean createDestIfNotExist = true;
        try {
            if (src.isFile()) {
                FileUtils.moveFile((File)src, (File)dest);
            } else {
                FileUtils.moveDirectoryToDirectory((File)src, (File)dest, (boolean)true);
            }
            return true;
        }
        catch (IOException e) {
            log.error((Object)("{safeMove} Error during move operation: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean delete(File f) throws IOException {
        assert (f.exists());
        if (f.isDirectory()) {
            FileUtils.deleteDirectory((File)f);
            return true;
        }
        return f.delete();
    }

    public static boolean smartEquals(File one, File two, boolean checkName) throws IOException {
        if (checkName && !one.getName().equals(two.getName())) {
            return false;
        }
        if (one.isDirectory() == two.isDirectory()) {
            if (one.isDirectory()) {
                File[] filesTwo;
                File[] filesOne = one.listFiles();
                if (filesOne.length == (filesTwo = two.listFiles()).length) {
                    if (filesOne.length > 0) {
                        for (int i = 0; i < filesOne.length; ++i) {
                            if (FileHelper.smartEquals(filesOne[i], filesTwo[i], checkName)) continue;
                            return false;
                        }
                        return true;
                    }
                    return true;
                }
                return false;
            }
            if (one.isFile() && two.isFile()) {
                if (one.length() == two.length()) {
                    return FileUtils.contentEquals((File)one, (File)two);
                }
                return false;
            }
            throw new IOException("I don't know how to handle a non-file non-directory File: one=" + one + " two=" + two);
        }
        return false;
    }

    public static long readPID(File f) throws IOException {
        return FileHelper.readPID(f, false);
    }

    public static long readPID(File f, boolean carefulProcessing) throws IOException {
        if (f.exists()) {
            String pidString = FileHelper.cat(f);
            pidString = carefulProcessing ? pidString.replaceAll("[^0-9]", "") : pidString.replace("\n", "");
            if (pidString.length() > 0) {
                return Long.parseLong(pidString);
            }
            return -1L;
        }
        return -1L;
    }

    public static void writePID(File f, long pid) throws IOException {
        FileHelper.writePID(f, Long.toString(pid));
    }

    public static void writePID(File f, String pid) throws IOException {
        assert (pid != null && pid.length() != 0) : "Must supply a valid PID!";
        FileHelper.write(f, pid);
    }

    public static void write(File f, String contents) throws IOException {
        FileHelper.write(f, new StringReader(contents));
    }

    public static void write(File f, StringBuilder sb) throws IOException {
        FileHelper.write(f, new StringBuilderReader(sb));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(File f, Reader fr) throws IOException {
        assert (f != null) : "Must supply a file to write to!";
        assert (fr != null) : "Must supply a Reader to read from!";
        FileWriter fw = new FileWriter(f);
        try {
            char[] buffer = new char[4096];
            int size = 0;
            while ((size = fr.read(buffer)) != -1) {
                fw.write(buffer, 0, size);
            }
        }
        finally {
            fw.close();
            fr.close();
        }
    }

    public static String cat(String filename) throws IOException {
        return FileHelper.cat(new File(filename));
    }

    public static String cat(InputStream is) throws IOException {
        return FileHelper.cat(new InputStreamReader(is), 1024);
    }

    public static String cat(URL u) throws IOException {
        return FileHelper.cat(u.openStream());
    }

    public static String cat(Reader reader) throws IOException {
        return FileHelper.cat(reader, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cat(File f) throws IOException {
        try (FileInputStream fis = new FileInputStream(f);){
            String string = FileHelper.cat(fis);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cat(Reader reader, int sizeEstimate) throws IOException {
        assert (reader != null) : "Must provide a reader to read from!";
        try {
            StringBuilder sb = new StringBuilder(sizeEstimate);
            char[] buffer = new char[4096];
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static boolean chown(File f, String owner, String group, boolean recursive) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot chown a non-existant file!");
        }
        if (owner == null) {
            owner = "";
        } else if (group == null) {
            group = "";
        }
        if (owner.isEmpty() && group.isEmpty()) {
            throw new IllegalArgumentException("Must specify an owner or a group to change ownership to");
        }
        String ownerGroupPair = group.isEmpty() ? owner : owner + "." + group;
        try {
            String[] cmd = recursive ? new String[]{"chown", "--recursive", ownerGroupPair, f.getPath()} : new String[]{"chown", ownerGroupPair, f.getPath()};
            Execed call = Exec.rootUtility(cmd);
            int returnCode = call.waitForExit();
            return returnCode == 0;
        }
        catch (Exception e) {
            log.error((Object)("[FileHelper] {chown} Failure: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean chmod(File f, int permissions) {
        return FileHelper.chmod(null, f, permissions);
    }

    public static boolean chmod(String as, File f, int permissions) {
        if (!f.exists()) {
            log.error((Object)("[FileHelper] {chmod} Non-existant file: " + f.getPath()));
            return false;
        }
        try {
            Execed call = Exec.utilityAs(as, "chmod", Integer.toOctalString(permissions), f.getPath());
            int returnCode = call.waitForExit();
            return returnCode == 0;
        }
        catch (Exception e) {
            log.error((Object)("[FileHelper] {chmod} Failure: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean chmod(File f, File copyOf) {
        return FileHelper.chmod(null, f, copyOf);
    }

    public static boolean chmod(String as, File f, File copyOf) {
        if (!f.exists()) {
            log.error((Object)("[FileHelper] {chmod} Non-existant file: " + f.getPath()));
            return false;
        }
        if (!copyOf.exists()) {
            log.error((Object)("[FileHelper] {chmod} Non-existant file: " + copyOf.getPath()));
            return false;
        }
        try {
            Execed call = Exec.utilityAs(as, "chmod", "--reference=" + copyOf.getPath(), f.getPath());
            int returnCode = call.waitForExit();
            return returnCode == 0;
        }
        catch (Exception e) {
            log.error((Object)("[LockRecord] {chmod} Failure: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static boolean chmod(String as, File f, Set<ChmodBit> set) {
        return FileHelper.chmod(as, f, set, null);
    }

    public static boolean chmod(File f, Set<ChmodBit> set) {
        return FileHelper.chmod(null, f, set);
    }

    public static boolean chmod(File f, Set<ChmodBit> set, Set<ChmodBit> clear) {
        return FileHelper.chmod(null, f, set, clear);
    }

    public static boolean chmod(String as, File f, Set<ChmodBit> set, Set<ChmodBit> clear) {
        if (!f.exists()) {
            log.error((Object)("[FileHelper] {chmod} Non-existant file: " + f.getPath()));
            return false;
        }
        String permissions = ChmodBit.toString(set, clear);
        try {
            Execed call = Exec.utilityAs(as, "chmod", permissions, f.getPath());
            int returnCode = call.waitForExit();
            return returnCode == 0;
        }
        catch (Exception e) {
            log.error((Object)("[LockRecord] {chmod} Failure: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public static LockRecord lockFile(File f) {
        LockRecord rec = new LockRecord();
        try {
            rec.fos = new FileOutputStream(f);
            rec.channel = rec.fos.getChannel();
            rec.flock = rec.channel.lock();
        }
        catch (IOException e) {
            log.error((Object)("[FileHelper] {lockFile} Error while locking " + f + ". Error: " + e.getMessage()), (Throwable)e);
            if (rec != null) {
                rec.release();
            }
            return null;
        }
        return rec;
    }

    public static void touch(File f) throws IOException {
        boolean success;
        if (!f.createNewFile() && !(success = f.setLastModified(System.currentTimeMillis()))) {
            log.warn((Object)("[FileHelper] {touch} Failed to update modify time on " + f));
        }
    }

    public static class LockRecord {
        protected FileOutputStream fos;
        protected FileChannel channel;
        protected FileLock flock;

        public void release() {
            try {
                if (this.flock != null && this.flock.isValid()) {
                    this.flock.release();
                }
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
                if (this.fos != null) {
                    this.fos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

