/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import com.peterphi.std.util.ListUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Writer;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMWriter;

public class PKCS12ToPEM {
    private static final transient Logger log = Logger.getLogger(PKCS12ToPEM.class);

    public static void convert(File pkcs12, File certPem, File keyPem) throws Exception {
        PKCS12ToPEM.convert(pkcs12, new char[0], new char[0], certPem, keyPem);
    }

    public static void convert(File pkcs12, char[] pkcs12Password, File certPem, File keyPem) throws Exception {
        PKCS12ToPEM.convert(pkcs12, pkcs12Password, new char[0], certPem, keyPem);
    }

    public static void convert(File pkcs12, char[] pkcs12Password, char[] keyPassword, File certPem, File keyPem) throws Exception {
        KeyStore ks = KeyStore.getInstance("PKCS12", "BC");
        ks.load(new FileInputStream(pkcs12), pkcs12Password);
        PEMWriter cert = new PEMWriter((Writer)new FileWriter(certPem));
        PEMWriter key = new PEMWriter((Writer)new FileWriter(keyPem));
        for (String alias : ListUtility.iterate(ks.aliases())) {
            boolean isKey = ks.isKeyEntry(alias);
            if (!isKey) continue;
            Key k = ks.getKey(alias, keyPassword);
            cert.writeObject((Object)ks.getCertificate(alias));
            key.writeObject((Object)k);
        }
        cert.close();
        key.close();
    }

    static {
        if (Security.getProvider(BouncyCastleProvider.PROVIDER_NAME) == null) {
            log.debug((Object)"[PKCS12ToPEM] {static} Initialising BC Provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

