/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.digest.impl;

import com.peterphi.std.crypto.digest.DigestAlgorithm;
import com.peterphi.std.crypto.digest.IDigestVerifier;
import com.peterphi.std.crypto.digest.IDigester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ByteChannel;

public class DigestVerifier
implements IDigestVerifier {
    private final String digest;
    private final IDigester algorithm;

    public DigestVerifier(String digest, DigestAlgorithm algorithm) {
        this(digest, algorithm.getImplementation());
    }

    public DigestVerifier(String digest, IDigester algorithm) {
        if (digest == null) {
            throw new IllegalArgumentException("Cannot verify if the expected digest is null!");
        }
        if (algorithm == null) {
            throw new IllegalArgumentException("Cannot verify if the algorithm is null!");
        }
        if (digest.isEmpty()) {
            throw new IllegalArgumentException("Cannot verify if the digest is the empty string!");
        }
        this.digest = digest;
        this.algorithm = algorithm;
    }

    @Override
    public boolean verify(byte[] content) {
        return this.eq(this.algorithm.digest(content), this.digest);
    }

    @Override
    public boolean verify(File file) throws IOException {
        return this.eq(this.algorithm.digest(file), this.digest);
    }

    @Override
    public boolean verify(InputStream is) throws IOException {
        return this.eq(this.algorithm.digest(is), this.digest);
    }

    @Override
    public boolean verify(ByteChannel channel) throws IOException {
        return this.eq(this.algorithm.digest(channel), this.digest);
    }

    private boolean eq(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        return a.compareToIgnoreCase(b) == 0;
    }
}

