/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.util;

import java.util.Random;
import java.util.StringTokenizer;

public class HexHelper {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private HexHelper() {
    }

    public static final byte[] fromHex(String value) {
        if (value.length() == 0) {
            return new byte[0];
        }
        if (value.indexOf(58) != -1) {
            return HexHelper.fromHex(':', value);
        }
        if (value.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hex specified: uneven number of digits passed for byte[] conversion");
        }
        byte[] buffer = new byte[value.length() / 2];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)Integer.parseInt(value.substring(j, j + 2), 16);
            j += 2;
        }
        return buffer;
    }

    public static final byte[] fromHex(char separator, String value) {
        if (value.length() == 0) {
            return new byte[0];
        }
        String sepString = new String(new char[]{separator});
        StringTokenizer t = new StringTokenizer(value, sepString, false);
        byte[] buffer = new byte[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens()) {
            String hex = t.nextToken();
            if (hex.length() == 2) {
                buffer[i++] = (byte)Integer.parseInt(hex, 16);
                continue;
            }
            throw new IllegalArgumentException("Hex section of length " + hex.length() + " encountered inside hex string: " + value + " with separator " + separator);
        }
        return buffer;
    }

    public static final byte[] generateBytes(int bytes) {
        return HexHelper.generateBytes(new Random(), bytes);
    }

    public static final byte[] generateBytes(Random rand, int bytes) {
        if (bytes < 1) {
            throw new IllegalArgumentException("bytes must be >= 1");
        }
        byte[] buffer = new byte[bytes];
        rand.nextBytes(buffer);
        return buffer;
    }

    public static final String generateHex(int characters) {
        return HexHelper.generateHex(new Random(), characters);
    }

    public static final String generateHex(Random random, int characters) {
        if (characters < 1) {
            throw new IllegalArgumentException("characters must be >= 1");
        }
        char[] str = new char[characters];
        for (int i = 0; i < characters; ++i) {
            str[i] = hex[random.nextInt(16)];
        }
        return new String(str);
    }

    public static final String toHex(byte ... bin) {
        if (bin == null || bin.length == 0) {
            return "";
        }
        char[] buffer = new char[bin.length * 2];
        int j = 0;
        for (int i = 0; i < bin.length; ++i) {
            byte b = bin[i];
            buffer[j++] = hex[b >> 4 & 0xF];
            buffer[j++] = hex[b & 0xF];
        }
        return new String(buffer);
    }

    public static final String toHex(char separator, byte ... bin) {
        if (bin == null || bin.length == 0) {
            return "";
        }
        char[] buffer = new char[bin.length * 3 - 1];
        int end = bin.length - 1;
        int base = 0;
        for (int i = 0; i < bin.length; ++i) {
            byte b = bin[i];
            buffer[base++] = hex[b >> 4 & 0xF];
            buffer[base++] = hex[b & 0xF];
            if (i == end) continue;
            buffer[base++] = separator;
        }
        return new String(buffer);
    }
}

