/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.threading.retry;

import com.peterphi.std.threading.retry.Retryable;
import com.peterphi.std.threading.retry.backoff.BackoffStrategy;
import org.apache.log4j.Logger;

public class RetryManager {
    private static final Logger log = Logger.getLogger(RetryManager.class);
    private final BackoffStrategy backoff;
    private final int maxAttempts;

    public RetryManager(BackoffStrategy strategy, int maxAttempts) {
        if (strategy == null) {
            throw new IllegalArgumentException("Must provide a backoff strategy!");
        }
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("Must provide max attempts!");
        }
        this.backoff = strategy;
        this.maxAttempts = maxAttempts;
    }

    public <T> T run(Retryable<T> operation) throws Exception {
        int attempt = 1;
        while (true) {
            if (attempt != 1) {
                this.sleep(attempt);
            }
            try {
                return operation.attempt(attempt);
            }
            catch (Throwable e) {
                boolean retry;
                boolean bl = retry = !this.maxAttemptsReached(attempt) && operation.shouldRetry(attempt, e);
                if (!retry) {
                    return this.finalAttemptFailed(operation, attempt, e);
                }
                log.warn((Object)("Attempt #" + attempt + " of " + operation + " failed, will retry."), e);
                ++attempt;
                continue;
            }
            break;
        }
    }

    protected boolean maxAttemptsReached(int attempt) {
        return attempt >= this.maxAttempts;
    }

    protected <T> T finalAttemptFailed(Retryable<T> operation, int attempt, Throwable e) throws Exception {
        log.error((Object)("Final attempt #" + attempt + " of " + operation + " failed."), e);
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public <T> T runUnchecked(Retryable<T> operation) throws RuntimeException {
        try {
            return this.run(operation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Retryable " + operation + " failed: " + e.getMessage(), e);
        }
    }

    private void sleep(int attempt) {
        long sleepTime = this.backoff.getBackoff(attempt);
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
    }
}

