/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.net;

import com.peterphi.std.net.NoInterfaceException;
import com.peterphi.std.net.NoMacAddressException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class IpHelper {
    private static final Logger log = Logger.getLogger(IpHelper.class);
    public static final Inet4Address QUAD_ZERO = (Inet4Address)IpHelper.ntoa(0);
    public static final Inet4Address BROADCAST_ADDRESS = (Inet4Address)IpHelper.ntoa(-1);
    public static final Inet6Address IPV6_ZERO = (Inet6Address)IpHelper.stoa("::");
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private IpHelper() {
    }

    public static String getLocalhost() throws RuntimeException {
        String hostname = null;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("[FileHelper] {getLocalhost}: Can't get local hostname");
        }
        return hostname;
    }

    public static String getLocalIp() throws RuntimeException {
        try {
            InetAddress addr = IpHelper.getLocalIpAddress();
            return addr.getHostAddress();
        }
        catch (RuntimeException e) {
            throw new RuntimeException("[FileHelper] {getLocalIp}: Unable to find the local machine", e);
        }
    }

    public static InetAddress getLocalIpAddress() throws RuntimeException {
        try {
            List<InetAddress> ips = IpHelper.getLocalIpAddresses(false, true);
            for (InetAddress ip : ips) {
                log.debug((Object)("[IpHelper] {getLocalIpAddress} Considering locality of " + ip.getHostAddress()));
                if (ip.isAnyLocalAddress() || !(ip instanceof Inet4Address) || ip.getHostAddress().startsWith("127.0.")) continue;
                log.debug((Object)("[IpHelper] {getLocalIpAddress} Found nonloopback IP: " + ip.getHostAddress()));
                return ip;
            }
            log.trace((Object)("[IpHelper] {getLocalIpAddress} Couldn't find a public IP in the ip (size " + ips.size() + ")"));
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("[FileHelper] {getLocalIp}: Unable to acquire the current machine's InetAddress", e);
        }
    }

    public static InetAddress getLocalIpAddress(String iface) throws RuntimeException {
        try {
            NetworkInterface nic = NetworkInterface.getByName(iface);
            Enumeration<InetAddress> ips = nic.getInetAddresses();
            InetAddress firstIP = null;
            while (ips != null && ips.hasMoreElements()) {
                InetAddress ip = ips.nextElement();
                if (firstIP == null) {
                    firstIP = ip;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[IpHelper] {getLocalIpAddress} Considering locality: " + ip.getHostAddress()));
                }
                if (ip.isAnyLocalAddress()) continue;
                return ip;
            }
            return firstIP;
        }
        catch (SocketException e) {
            throw new RuntimeException("[IpHelper] {getLocalIpAddress}: Unable to acquire an IP", e);
        }
    }

    public static List<InetAddress> getLocalIpAddresses() throws RuntimeException {
        return IpHelper.getLocalIpAddresses(false, false);
    }

    public static List<InetAddress> getLocalIpAddresses(boolean pruneSiteLocal) throws RuntimeException {
        return IpHelper.getLocalIpAddresses(pruneSiteLocal, false);
    }

    public static List<InetAddress> getLocalIpAddresses(boolean pruneSiteLocal, boolean pruneDown) throws RuntimeException {
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            Vector<InetAddress> addresses = new Vector<InetAddress>();
            while (nics.hasMoreElements()) {
                NetworkInterface iface = nics.nextElement();
                Enumeration<InetAddress> addrs = iface.getInetAddresses();
                if (pruneDown && !iface.isUp()) continue;
                while (addrs.hasMoreElements()) {
                    InetAddress addr = addrs.nextElement();
                    if (addr.isLoopbackAddress() || addr.isLinkLocalAddress() || pruneSiteLocal && (!pruneSiteLocal || addr.isSiteLocalAddress())) continue;
                    addresses.add(addr);
                }
            }
            return addresses;
        }
        catch (SocketException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getMacForLocalIp(InetAddress addr) throws SocketException, NoMacAddressException, NoInterfaceException {
        return IpHelper.getMacFor(IpHelper.getInterfaceForLocalIp(addr));
    }

    public static String getMacFor(NetworkInterface iface) throws SocketException, NoMacAddressException {
        assert (iface != null);
        byte[] hwaddr = iface.getHardwareAddress();
        if (hwaddr == null || hwaddr.length == 0) {
            throw new NoMacAddressException("Interface " + iface.getName() + " has no physical address specified.");
        }
        return IpHelper.physicalAddressToString(hwaddr);
    }

    public static NetworkInterface getInterfaceForLocalIp(InetAddress addr) throws SocketException, NoInterfaceException {
        assert (IpHelper.getLocalIpAddresses(false).contains(addr)) : "IP is not local";
        NetworkInterface iface = NetworkInterface.getByInetAddress(addr);
        if (iface != null) {
            return iface;
        }
        throw new NoInterfaceException("No network interface for IP: " + addr.toString());
    }

    public static String physicalAddressToString(byte[] addr) {
        StringBuffer sb = new StringBuffer(addr.length * 3 - 1);
        int i = 0;
        while (true) {
            byte lo = (byte)(addr[i] & 0xF);
            byte hi = (byte)((addr[i] & 0xF0) >>> 4);
            sb.append(hex[hi]);
            sb.append(hex[lo]);
            if (i + 1 >= addr.length) break;
            sb.append(":");
            ++i;
        }
        return sb.toString();
    }

    public static List<InetAddress> getLocalIpAddresses(String ifaceName, boolean pruneSiteLocal) throws RuntimeException {
        try {
            NetworkInterface iface = NetworkInterface.getByName(ifaceName);
            Vector<InetAddress> addresses = new Vector<InetAddress>();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() && (!pruneSiteLocal || addr.isLinkLocalAddress())) continue;
                addresses.add(addr);
            }
            return addresses;
        }
        catch (SocketException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static boolean isValidNetmask(String netmask) {
        try {
            return IpHelper.isValidNetmask(InetAddress.getByName(netmask));
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isValidNetmask(InetAddress netmask) {
        byte[] segments = netmask.getAddress();
        return IpHelper.isValidNetmask(segments);
    }

    public static boolean isValidNetmask(byte[] segments) {
        boolean mustBeZero = false;
        block5: for (int i = 0; i < segments.length; ++i) {
            switch (segments[i]) {
                case -1: {
                    if (!mustBeZero) continue block5;
                    return false;
                }
                case 0: {
                    if (mustBeZero) continue block5;
                }
                case -128: 
                case -64: 
                case -32: 
                case -16: 
                case -8: 
                case -4: 
                case -2: {
                    if (!mustBeZero) {
                        mustBeZero = true;
                        continue block5;
                    }
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static int netmaskToPrefix(InetAddress netmask) {
        byte[] mask = netmask.getAddress();
        if (!IpHelper.isValidNetmask(mask)) {
            throw new IllegalArgumentException("Not a valid netmask: " + netmask.getHostAddress());
        }
        int prefix = 0;
        block10: for (int i = 0; i < mask.length; ++i) {
            switch (mask[i]) {
                case -1: {
                    prefix += 8;
                    continue block10;
                }
                case -2: {
                    ++prefix;
                }
                case -4: {
                    ++prefix;
                }
                case -8: {
                    ++prefix;
                }
                case -16: {
                    ++prefix;
                }
                case -32: {
                    ++prefix;
                }
                case -64: {
                    ++prefix;
                }
                case -128: {
                    ++prefix;
                }
            }
        }
        return prefix;
    }

    public static InetAddress prefixToNetmask(int prefix) {
        return IpHelper.ntoa(IpHelper.prefixToMask(prefix));
    }

    public static int prefixToMask(int prefix) {
        if (prefix != 0) {
            return -1 << 32 - prefix;
        }
        return 0;
    }

    public static boolean isValidCiscoWildcard(InetAddress wildcard) {
        byte[] segments = wildcard.getAddress();
        for (int i = 0; i < segments.length; ++i) {
            assert ((byte)(~((byte)(~segments[i]))) == segments[i]);
            segments[i] = ~segments[i];
        }
        return IpHelper.isValidNetmask(segments);
    }

    public static boolean isLocalAddress(String addr) {
        try {
            InetAddress iAddr = InetAddress.getByName(addr);
            return IpHelper.isLocalAddress(iAddr);
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static boolean isLocalAddress(InetAddress addr) {
        if (addr.isLoopbackAddress()) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                Enumeration<InetAddress> addrs = nics.nextElement().getInetAddresses();
                while (addrs.hasMoreElements()) {
                    if (!addrs.nextElement().equals(addr)) continue;
                    return true;
                }
            }
        }
        catch (SocketException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
        log.debug((Object)("[FileHelper] {isLocalAddress} not local: " + addr.getHostAddress()));
        return false;
    }

    public static InetAddress stoa(String ip) {
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("must pass a valid ip: null or empty strings are not valid IPs!");
        }
        try {
            return InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("must pass a valid ip. Illegal input was: " + ip, e);
        }
    }

    public static int aton(String ip) {
        try {
            return IpHelper.aton(InetAddress.getByName(ip));
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("must pass a valid ip. Illegal input was: " + ip, e);
        }
    }

    public static int aton(InetAddress ip) {
        if (ip == null) {
            throw new Error("the result of aton(null) is undefined");
        }
        if (ip instanceof Inet4Address) {
            return IpHelper.aton((Inet4Address)ip);
        }
        throw new Error("int aton(InetAddress) does not function for " + ip.getClass());
    }

    public static int aton(Inet4Address ip) {
        return IpHelper.aton(ip.getAddress());
    }

    public static int aton(byte[] addr) {
        int address = addr[3] & 0xFF;
        address |= addr[2] << 8 & 0xFF00;
        address |= addr[1] << 16 & 0xFF0000;
        return address |= addr[0] << 24 & 0xFF000000;
    }

    public static InetAddress ntoa(byte[] addr) {
        try {
            if (addr.length == 4 || addr.length == 16) {
                return InetAddress.getByAddress(addr);
            }
            throw new IllegalArgumentException("a byte[] address for ntoa must be 4 bytes (ipv4) or 16 bytes (ipv6)");
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    public static InetAddress ntoa(int address) {
        try {
            byte[] addr = new byte[]{(byte)(address >>> 24 & 0xFF), (byte)(address >>> 16 & 0xFF), (byte)(address >>> 8 & 0xFF), (byte)(address & 0xFF)};
            return InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    public static InetAddress parse(String ip) {
        if (ip == null || ip.isEmpty()) {
            throw new IllegalArgumentException("A null or empty string is not a valid IP address!");
        }
        try {
            return InetAddress.getByName(ip);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Not a valid IP address: " + ip, t);
        }
    }

    @Deprecated
    public static boolean isPublicallyRoutable(InetAddress addrIP) {
        return IpHelper.isPubliclyRoutable(addrIP);
    }

    public static boolean isPubliclyRoutable(InetAddress addrIP) {
        if (addrIP == null) {
            throw new NullPointerException("isPubliclyRoutable requires an IP address be passed to it!");
        }
        return !addrIP.isSiteLocalAddress() && !addrIP.isLinkLocalAddress() && !addrIP.isLoopbackAddress();
    }
}

