/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.crypto.keystore;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;

public class DirectoryKeystore {
    private static final Logger log = Logger.getLogger(DirectoryKeystore.class);
    private final File _keyFolder;
    private final File _publicFolder;
    private final File _privateFolder;

    public DirectoryKeystore(File directory) {
        log.info((Object)("[DirectoryKeystore] {ctor} Initialising from " + directory.toString()));
        this._keyFolder = directory;
        this._publicFolder = new File(this._keyFolder, "public");
        this._privateFolder = new File(this._keyFolder, "private");
    }

    public PublicKey[] loadPublicKeys() {
        File[] files = this._publicFolder.listFiles();
        PublicKey[] buffer = new PublicKey[files.length];
        for (int i = 0; i < files.length; ++i) {
            buffer[i] = DirectoryKeystore.getPublicKey(files[i]);
        }
        return buffer;
    }

    public PrivateKey getPrivateKey(String name) {
        File keyFile = new File(this._privateFolder, name);
        return DirectoryKeystore.getPrivateKey(keyFile);
    }

    public PublicKey getPublicKey(String name) {
        File keyFile = new File(this._publicFolder, name);
        return DirectoryKeystore.getPublicKey(keyFile);
    }

    public boolean hasKeyPair(String name) {
        try {
            return this.getKeypair(name) != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public KeyPair getKeypair(String name) {
        PublicKey kPublic;
        PrivateKey kPrivate;
        try {
            log.debug((Object)"[DirectoryKeystore] {getKeypair} Getting private key");
            kPrivate = this.getPrivateKey(name);
        }
        catch (Exception e) {
            log.error((Object)("[DirectoryKeystore] {getKeypair} Error retrieving private key: " + e.getMessage()), (Throwable)e);
            kPrivate = null;
        }
        try {
            log.debug((Object)"[DirectoryKeystore] {getKeypair} Getting public key");
            kPublic = DirectoryKeystore.getPublicKey(new File(this._privateFolder, name));
        }
        catch (Exception e) {
            kPublic = null;
        }
        if (kPrivate != null && kPublic != null) {
            return new KeyPair(kPublic, kPrivate);
        }
        if (kPrivate == null && kPublic == null) {
            log.info((Object)("[DirectoryKeystore] {getKeypair} No public or private key '" + name + "' found"));
            return null;
        }
        if (kPrivate == null) {
            log.warn((Object)("[DocumentKeystore] {getKeypair} private:" + name + " not in private keystore."));
            return null;
        }
        if (kPublic == null) {
            log.warn((Object)("[DocumentKeystore] {getKeypair} public:" + name + " not in private keystore."));
            return null;
        }
        return null;
    }

    public boolean setPrivateKey(String name, PrivateKey pk) {
        return DirectoryKeystore.setKey(new File(this._privateFolder, name), pk);
    }

    public boolean setPublicKey(String name, PublicKey kpub) {
        return DirectoryKeystore.setKey(new File(this._publicFolder, name), kpub);
    }

    public boolean setPublicKey(String name, X509Certificate cert) {
        return DirectoryKeystore.setKey(new File(this._publicFolder, name), cert);
    }

    public boolean setKeypair(String name, KeyPair kp) {
        return DirectoryKeystore.setKey(new File(this._privateFolder, name), kp);
    }

    private static boolean setKey(File keyFile, Object keyObject) {
        try {
            PEMWriter w = new PEMWriter((Writer)new FileWriter(keyFile));
            w.writeObject(keyObject);
            w.close();
            return true;
        }
        catch (Throwable t) {
            log.error((Object)("[DirectoryKeystore] {setKey} Error writing key: " + t.getMessage()), t);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PrivateKey getPrivateKey(File keyFile) {
        try {
            if (!keyFile.exists()) return null;
            log.debug((Object)"[DirectoryKeystore] {getPrivateKey} Private keyfile exists.");
            PEMReader r = new PEMReader((Reader)new FileReader(keyFile), null, "BC");
            try {
                Object o;
                log.debug((Object)"[DirectoryKeystore] {getPrivateKey} PEM file loaded.");
                try {
                    o = r.readObject();
                }
                catch (Throwable e) {
                    log.error((Object)("[DirectoryKeystore] {getPrivateKey} Error reading keyfile (it might be encrypted?). Error: " + e.getMessage()), e);
                    PrivateKey privateKey = null;
                    IOUtils.closeQuietly((Reader)r);
                    return privateKey;
                }
                if (o instanceof KeyPair) {
                    KeyPair kp = (KeyPair)o;
                    PrivateKey privateKey = kp.getPrivate();
                    return privateKey;
                }
                if (o instanceof PrivateKey) {
                    PrivateKey privateKey = (PrivateKey)o;
                    return privateKey;
                }
                log.error((Object)("[DirectoryKeystore] Unknown key format: " + o.getClass()));
                PrivateKey privateKey = null;
                return privateKey;
            }
            finally {
                IOUtils.closeQuietly((Reader)r);
            }
        }
        catch (Exception e) {
            log.error((Object)("[DirectoryKeystore] {getPrivateKey} Error getting key: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static PublicKey getPublicKey(File keyFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        if (Security.getProvider("BC") == null) {
            log.debug((Object)"[DirectoryKeystore] {static} Initialising BC Provider");
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

