/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.serviceprops;

import com.google.inject.Injector;
import com.google.inject.MembersInjector;
import com.peterphi.std.annotation.Doc;
import com.peterphi.std.guice.common.serviceprops.ConfigurationPropertyRegistry;
import com.peterphi.std.guice.common.serviceprops.annotations.Reconfigurable;
import com.peterphi.std.guice.common.stringparsing.StringToTypeConverter;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;

public class ConfigurationPropertyBindingSite<T, O> {
    private final ConfigurationPropertyRegistry registry;
    private final AtomicReference<Injector> injector;
    private final Class<O> owner;
    private final String name;
    private final Class<T> type;
    private final AnnotatedElement element;

    public ConfigurationPropertyBindingSite(ConfigurationPropertyRegistry registry, AtomicReference<Injector> injector, Class<O> owner, String name, Class<T> type, AnnotatedElement element) {
        if (owner == null) {
            throw new IllegalArgumentException("Binding owner must not be null!");
        }
        this.registry = registry;
        this.injector = injector;
        this.owner = owner;
        this.name = name;
        this.type = type;
        this.element = element;
    }

    public Class getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isDeprecated() {
        return this.element.isAnnotationPresent(Deprecated.class);
    }

    public boolean isReconfigurable() {
        return this.element.isAnnotationPresent(Reconfigurable.class);
    }

    public String getDescription() {
        Doc doc = this.element.getAnnotation(Doc.class);
        if (doc != null) {
            return StringUtils.join((Object[])doc.value(), (String)"\n");
        }
        return null;
    }

    public String[] getHrefs() {
        Doc doc = this.element.getAnnotation(Doc.class);
        if (doc != null && doc.href() != null && doc.href().length > 0) {
            return doc.href();
        }
        return null;
    }

    public String toString() {
        return "BindingSite{owner=" + this.owner + ", name='" + this.name + '\'' + ", type=" + this.type + ", element=" + this.element + '}';
    }

    public void validate(String value) {
        try {
            StringToTypeConverter.convert(this.getType(), value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse \"" + value + "\" as " + this.type + " for binding in " + this.owner + ": " + e.getMessage(), e);
        }
    }

    void reinject(Iterable<Object> objects) {
        MembersInjector injector = this.injector.get().getMembersInjector(this.owner);
        for (Object obj : objects) {
            if (obj == null) continue;
            injector.injectMembers(this.owner.cast(obj));
        }
    }

    public Set<Object> get(Iterable<Object> objects) {
        if (this.element instanceof Field) {
            Field field = (Field)this.element;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                HashSet<Object> values = new HashSet<Object>();
                for (Object object : objects) {
                    values.add(field.get(object));
                }
                return values;
            }
            catch (IllegalAccessException e) {
                return Collections.emptySet();
            }
        }
        return Collections.emptySet();
    }
}

