/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.metrics;

import com.codahale.metrics.MetricRegistry;
import com.peterphi.std.annotation.Doc;

public final class GuiceMetricNames {
    @Doc(value={"The number of @Retry annotated methods that have been called"})
    public static final String RETRY_CALLS = "feature.auto-retry.calls";
    @Doc(value={"The number of tries (including the first try) made on @Retry annotated methods"})
    public static final String RETRY_ATTEMPTS = "feature.auto-retry.attempts";
    @Doc(value={"The number of tries (including the first try) made on @Retry annotated methods that have failed"})
    public static final String RETRY_ATTEMPT_FAILURES = "feature.auto-retry.attempt-failures";
    @Doc(value={"The number of @Retry annotated methods that have failed despite retries"})
    public static final String RETRY_TOTAL_FAILURES = "feature.auto-retry.failures";
    public static final String HTTP_CALLS_TIMER = "feature.jax-rs-http-server.calls";
    public static final String HTTP_EXCEPTIONS_METER = "feature.jax-rs-http-server.calls.non-404-exception";
    public static final String HTTP_404_EXCEPTIONS_METER = "feature.jax-rs-http-server.calls.404-exception";
    public static final String HTTP_IGNORED_CLIENT_ABORTS = "feature.jax-rs-http-server.calls.ignored-client-abort";
    @Doc(value={"The number of calls to a @Transactional method (including calls that do not start a transaction)"})
    public static final String TRANSACTION_CALLS_TIMER = "feature.transactional.all-calls";
    @Doc(value={"The number of calls to a @Transactional method that start a transaction"})
    public static final String TRANSACTION_OWNER_CALLS_TIMER = "feature.transaction.owner-calls";
    @Doc(value={"The number of calls to a @Transactional method that result in a transaction rollback"})
    public static final String TRANSACTION_ERROR_ROLLBACK_METER = "feature.transaction.rollback.exception";
    @Doc(value={"The number of calls to a @Transactional method where the commit has been attempted but failed"})
    public static final String TRANSACTION_COMMIT_FAILURE_METER = "feature.transaction.commit.failures";
    public static final String THYMELEAF_CALL_TIMER = "feature.thymeleaf.calls";
    public static final String THYMELEAF_RENDER_EXCEPTION_METER = "feature.thymeleaf.exception";
    @Doc(value={"Keeps track of the number of requests that have been made"})
    public static final String AUTH_CONSTRAINT_CALL_METER = "feature.AuthConstraint.calls";
    @Doc(value={"Keeps track of the number of requests that have been granted"})
    public static final String AUTH_CONSTRAINT_GRANTED_METER = "feature.AuthConstraint.allow";
    @Doc(value={"Keeps track of the number of requests that have been denied"})
    public static final String AUTH_CONSTRAINT_DENIED_METER = "feature.AuthConstraint.deny";
    @Doc(value={"Keeps track of the number of requests from logged in users (i.e. non-anonymous) which have been denied"})
    public static final String AUTH_CONSTRAINT_AUTHENTICATED_DENIED_METER = "feature.AuthConstraint.authenticated-deny";
    @Doc(value={"The number of @Cache annotated methods that have returned a cached result"})
    public static final String CACHE_HITS = "cache.hits";
    @Doc(value={"The number of @Cache annotated methods that have had to calculate a result"})
    public static final String CACHE_MISSES = "cache.misses";

    private GuiceMetricNames() {
    }

    public static String name(Class<?> clazz, String ... names) {
        if (clazz.getName().contains("$$EnhancerByGuice$$")) {
            clazz = clazz.getSuperclass();
        }
        return MetricRegistry.name(clazz, (String[])names);
    }
}

