/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.eagersingleton;

import com.codahale.metrics.MetricRegistry;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.peterphi.std.guice.apploader.GuiceRole;
import com.peterphi.std.guice.apploader.GuiceSetup;
import com.peterphi.std.guice.common.ClassScanner;
import com.peterphi.std.guice.common.ClassScannerFactory;
import com.peterphi.std.guice.common.eagersingleton.BindEagerSingletonModule;
import com.peterphi.std.guice.common.eagersingleton.annotations.EagerSingleton;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;

public class BindEagerSingletonRole
implements GuiceRole {
    private static final Logger log = Logger.getLogger(BindEagerSingletonRole.class);

    @Override
    public void adjustConfigurations(List<Configuration> configs) {
    }

    @Override
    public void register(Stage stage, ClassScannerFactory scannerFactory, CompositeConfiguration config, PropertiesConfiguration overrides, GuiceSetup setup, List<Module> modules, AtomicReference<Injector> injectorRef, MetricRegistry metrics) {
        ClassScanner scanner = scannerFactory.getInstance();
        if (scanner != null) {
            List<Class<?>> classes = scanner.getAnnotatedClasses(EagerSingleton.class);
            boolean isTestEnvironment = config.getBoolean("unit-test", false);
            Iterator<Class<?>> it = classes.iterator();
            while (it.hasNext()) {
                EagerSingleton annotation;
                Class<?> clazz = it.next();
                if (isTestEnvironment && !(annotation = clazz.getAnnotation(EagerSingleton.class)).inTests()) {
                    log.trace((Object)("Ignoring eager singleton with inTests=false: " + clazz));
                    it.remove();
                    continue;
                }
                log.trace((Object)("Binding eager singleton: " + clazz));
            }
            if (!classes.isEmpty()) {
                modules.add((Module)new BindEagerSingletonModule(classes));
            }
        }
    }

    @Override
    public void injectorCreated(Stage stage, ClassScannerFactory scanner, CompositeConfiguration config, PropertiesConfiguration overrides, GuiceSetup setup, List<Module> modules, AtomicReference<Injector> injectorRef, MetricRegistry metrics) {
    }
}

