/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.auth.iface;

import com.peterphi.std.guice.common.auth.iface.AccessRefuser;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public interface CurrentUser {
    public static final DateTimeFormatter DEFAULT_DATE_FORMAT = DateTimeFormat.forPattern((String)"YYYY-MM-dd HH:mm:ss zzz").withZoneUTC();

    public String getAuthType();

    public boolean isAnonymous();

    public String getName();

    public String getUsername();

    public boolean hasRole(String var1);

    public DateTime getExpires();

    public Map<String, Object> getClaims();

    default public String getSimpleClaim(String name) {
        Object value = this.getClaims().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String || value instanceof Number) {
            return value.toString();
        }
        throw new IllegalArgumentException("Claim " + name + " did not have list of simple value as expected. Had: " + value);
    }

    default public List<String> getSimpleListClaim(String name) {
        Object value = this.getClaims().get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List claim = (List)value;
            ArrayList<String> ret = new ArrayList<String>(claim.size());
            for (Object entry : claim) {
                if (value == null) {
                    ret.add(null);
                    continue;
                }
                if (value instanceof String || value instanceof Number) {
                    ret.add(entry.toString());
                    continue;
                }
                throw new IllegalArgumentException("Claim " + name + " did not have list of simple value as expected. Had: " + value);
            }
            return ret;
        }
        throw new IllegalArgumentException("Claim " + name + " did not have list of simple value as expected. Had: " + value);
    }

    default public Set<String> getSimpleSetClaim(String name) {
        return new HashSet<String>(this.getSimpleListClaim(name));
    }

    default public String format(DateTime date) {
        if (date != null) {
            return DEFAULT_DATE_FORMAT.print((ReadableInstant)date);
        }
        return null;
    }

    default public String format(Instant date) {
        if (date == null) {
            return this.format((DateTime)null);
        }
        return this.format(new DateTime(date.toEpochMilli()));
    }

    default public String format(Date date) {
        if (date == null) {
            return this.format((DateTime)null);
        }
        return this.format(new DateTime(date.getTime()));
    }

    public AccessRefuser getAccessRefuser();
}

