/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.serviceprops;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.peterphi.std.guice.apploader.GuiceProperties;
import com.peterphi.std.guice.common.serviceprops.ConfigurationPropertyRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.Configuration;

public class ConfigurationPropertyRegistryModule
extends AbstractModule {
    private final ConfigurationPropertyRegistry registry;
    private final AtomicReference<Injector> injectorRef;

    public ConfigurationPropertyRegistryModule(Configuration configuration, Configuration overrides, AtomicReference<Injector> injectorRef) {
        this.registry = new ConfigurationPropertyRegistry(configuration, overrides);
        this.injectorRef = injectorRef;
    }

    protected void configure() {
        this.bind(ConfigurationPropertyRegistry.class).toInstance((Object)this.registry);
        ConfigurationPropertyRegistryModule.bindAllGuiceProperties(this.registry, this.injectorRef);
        this.bindListener(Matchers.any(), new NamedMemberExtractTypeListener(this.binder()));
    }

    private static void bindAllGuiceProperties(ConfigurationPropertyRegistry registry, AtomicReference<Injector> injector) {
        for (Field field : GuiceProperties.class.getFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                String propertyName = String.valueOf(field.get(null));
                registry.register(GuiceProperties.class, injector, propertyName, String.class, field);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error trying to process GuiceProperties." + field.getName(), e);
            }
        }
    }

    protected int processMethod(Class<?> clazz, Executable executable) {
        Annotation[][] annotations = executable.getParameterAnnotations();
        Class<?>[] types = executable.getParameterTypes();
        int discovered = 0;
        for (int i = 0; i < types.length; ++i) {
            Class<?> type = types[i];
            Named named = this.getNamedAnnotation(annotations[i]);
            if (named == null) continue;
            this.registry.register(clazz, this.injectorRef, named.value(), type, executable);
            ++discovered;
        }
        return discovered;
    }

    private Named getNamedAnnotation(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Named)) continue;
            return (Named)annotation;
        }
        return null;
    }

    private class NamedMemberExtractTypeListener
    implements TypeListener {
        private final Binder binder;

        public NamedMemberExtractTypeListener(Binder binder) {
            this.binder = binder;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            final Class discoveredType = type.getRawType();
            int reconfigurables = 0;
            for (Constructor<?> constructor : discoveredType.getDeclaredConstructors()) {
                if (!constructor.isAnnotationPresent(Inject.class)) continue;
                reconfigurables += ConfigurationPropertyRegistryModule.this.processMethod(discoveredType, constructor);
            }
            for (Class clazz = discoveredType; clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(Inject.class) || !field.isAnnotationPresent(Named.class)) continue;
                    Named named = field.getAnnotation(Named.class);
                    ConfigurationPropertyRegistryModule.this.registry.register(discoveredType, ConfigurationPropertyRegistryModule.this.injectorRef, named.value(), field.getType(), field);
                    ++reconfigurables;
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                    if (!accessibleObject.isAnnotationPresent(Inject.class)) continue;
                    reconfigurables += ConfigurationPropertyRegistryModule.this.processMethod(discoveredType, (Executable)accessibleObject);
                }
            }
            if (reconfigurables > 0) {
                encounter.register(new InjectionListener<I>(){

                    public void afterInjection(I injectee) {
                        ConfigurationPropertyRegistryModule.this.registry.addInstance(discoveredType, injectee);
                    }
                });
            }
        }
    }
}

