/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.inject.Inject;
import com.peterphi.std.guice.common.daemon.GuiceDaemon;
import com.peterphi.std.guice.common.metrics.GuiceMetricNames;
import com.peterphi.std.guice.common.stringparsing.StringToTypeConverter;
import com.peterphi.std.threading.Timeout;
import java.time.Instant;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class GuiceRecurringDaemon
extends GuiceDaemon {
    private static final Logger log = Logger.getLogger(GuiceRecurringDaemon.class);
    @Inject
    MetricRegistry metrics;
    private Timer calls;
    private Meter exceptions;
    protected Timeout sleepTime;
    private Instant lastRan = null;

    protected GuiceRecurringDaemon(Timeout sleepTime) {
        this(true, sleepTime);
    }

    protected GuiceRecurringDaemon(boolean daemonThread, Timeout sleepTime) {
        super(daemonThread);
        if (sleepTime == null || sleepTime.getMilliseconds() < 0L) {
            throw new IllegalArgumentException("Cannot provide a negative sleep time!");
        }
        this.sleepTime = sleepTime;
    }

    @Inject
    public void setSleepTimeFromConfigIfSet(Configuration config) {
        String str = config.getString("daemon." + this.getName() + ".interval", null);
        if (StringUtils.isNotEmpty((String)str)) {
            Timeout timeout = (Timeout)StringToTypeConverter.convert(Timeout.class, str);
            if (timeout == null) {
                throw new IllegalArgumentException("Invalid interval config: " + str);
            }
            this.setSleepTime(timeout);
        }
    }

    public Timeout getSleepTime() {
        return this.sleepTime;
    }

    public Timer getCalls() {
        return this.calls;
    }

    public Meter getExceptions() {
        return this.exceptions;
    }

    public void setSleepTime(Timeout sleepTime) {
        this.sleepTime = sleepTime;
    }

    public void run() {
        while (this.isRunning()) {
            this.lastRan = Instant.now();
            Timer.Context timer = this.calls != null ? this.calls.time() : null;
            try {
                this.execute();
            }
            catch (Throwable t) {
                if (this.exceptions != null) {
                    this.exceptions.mark();
                }
                log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
            }
            finally {
                if (timer != null) {
                    timer.stop();
                }
            }
            if (!this.isRunning()) continue;
            this.sleep(this.sleepTime);
        }
    }

    public Instant getLastRan() {
        return this.lastRan;
    }

    protected void executeException(Throwable t) {
        log.error((Object)"Ignoring exception in GuiceRecurringDaemon call", t);
    }

    protected abstract void execute() throws Exception;

    @Override
    public void postConstruct() {
        this.calls = this.metrics.timer(GuiceMetricNames.name(this.getClass(), "calls"));
        this.exceptions = this.metrics.meter(GuiceMetricNames.name(this.getClass(), "exceptions"));
        super.postConstruct();
    }
}

