/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.daemon;

import com.google.inject.Inject;
import com.peterphi.std.annotation.ServiceName;
import com.peterphi.std.guice.common.daemon.GuiceDaemonRegistry;
import com.peterphi.std.guice.common.lifecycle.GuiceLifecycleListener;
import com.peterphi.std.guice.common.shutdown.iface.ShutdownManager;
import com.peterphi.std.guice.common.shutdown.iface.StoppableService;
import com.peterphi.std.threading.Daemon;
import com.peterphi.std.threading.Timeout;

public abstract class GuiceDaemon
extends Daemon
implements StoppableService,
GuiceLifecycleListener {
    private boolean daemonThread;
    @Inject
    ShutdownManager shutdownManager;
    @Inject
    GuiceDaemonRegistry registry;

    public GuiceDaemon() {
        this(true);
    }

    public GuiceDaemon(boolean daemonThread) {
        this.daemonThread = daemonThread;
    }

    protected boolean shouldStartAsDaemon() {
        return this.daemonThread;
    }

    @Override
    public void postConstruct() {
        this.startThread();
        this.shutdownManager.register(this);
        this.registry.register(this);
    }

    @Override
    public void shutdown() {
        this.stopThread();
        if (this.registry != null) {
            this.registry.unregister(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sleep(long millis) {
        if (!this.isRunning() || millis <= 0L) {
            return;
        }
        try {
            GuiceDaemon guiceDaemon = this;
            synchronized (guiceDaemon) {
                this.wait(millis);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void sleep(Timeout timeout) {
        this.sleep(timeout.getMilliseconds());
    }

    public String getName() {
        Class<?> clazz = this.getClass();
        if (clazz.getName().contains("$$EnhancerByGuice$$")) {
            clazz = clazz.getSuperclass();
        }
        if (clazz.isAnnotationPresent(ServiceName.class)) {
            return clazz.getAnnotation(ServiceName.class).value();
        }
        return clazz.getSimpleName();
    }

    protected String getThreadName() {
        return this.getName();
    }
}

