/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.auth;

import com.peterphi.std.guice.common.auth.annotations.AuthConstraint;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class DefaultAuthConstraintMethodInterceptor
implements MethodInterceptor {
    DefaultAuthConstraintMethodInterceptor() {
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getDeclaringClass().equals(Object.class)) {
            return invocation.proceed();
        }
        AuthConstraint constraint = this.readConstraint(invocation);
        if (constraint == null) {
            throw new IllegalArgumentException("Cannot find AuthConstraint associated with method: " + invocation.getMethod());
        }
        if (!constraint.skip()) {
            throw new IllegalArgumentException("Method call prohibited: method has auth constraints but no user provider has been configured");
        }
        return invocation.proceed();
    }

    private AuthConstraint readConstraint(MethodInvocation invocation) {
        if (invocation.getMethod().isAnnotationPresent(AuthConstraint.class)) {
            return invocation.getMethod().getAnnotation(AuthConstraint.class);
        }
        return invocation.getMethod().getDeclaringClass().getAnnotation(AuthConstraint.class);
    }
}

