/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.auth;

import com.codahale.metrics.Meter;
import com.google.inject.Provider;
import com.peterphi.std.guice.common.auth.annotations.AuthConstraint;
import com.peterphi.std.guice.common.auth.iface.CurrentUser;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

class AuthConstraintMethodInterceptor
implements MethodInterceptor {
    private final Provider<CurrentUser> userProvider;
    private final Meter calls;
    private final Meter granted;
    private final Meter denied;
    private final Meter authenticatedDenied;

    public AuthConstraintMethodInterceptor(Provider<CurrentUser> userProvider, Meter calls, Meter granted, Meter denied, Meter authenticatedDenied) {
        if (userProvider == null) {
            throw new IllegalArgumentException("Must have a Provider for CurrentUser!");
        }
        this.userProvider = userProvider;
        this.calls = calls;
        this.granted = granted;
        this.denied = denied;
        this.authenticatedDenied = authenticatedDenied;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (invocation.getMethod().getDeclaringClass().equals(Object.class)) {
            return invocation.proceed();
        }
        this.calls.mark();
        AuthConstraint constraint = this.readConstraint(invocation);
        CurrentUser user = (CurrentUser)this.userProvider.get();
        if (constraint == null) {
            throw new IllegalArgumentException("Cannot find AuthConstraint associated with method: " + invocation.getMethod());
        }
        if (user == null) {
            throw new IllegalArgumentException("Provider for CurrentUser returned null! Cannot apply AuthConstraint to method " + invocation.getMethod());
        }
        if (this.passes(constraint, user)) {
            this.granted.mark();
            return invocation.proceed();
        }
        if (!user.isAnonymous()) {
            this.authenticatedDenied.mark();
        }
        this.denied.mark();
        throw user.getAccessRefuser().refuse(constraint, user);
    }

    private boolean passes(AuthConstraint constraint, CurrentUser user) {
        if (constraint.skip()) {
            return true;
        }
        return user.hasRole(constraint.role());
    }

    private AuthConstraint readConstraint(MethodInvocation invocation) {
        if (invocation.getMethod().isAnnotationPresent(AuthConstraint.class)) {
            return invocation.getMethod().getAnnotation(AuthConstraint.class);
        }
        return invocation.getMethod().getDeclaringClass().getAnnotation(AuthConstraint.class);
    }
}

