/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.log4j.InstrumentedAppender;
import com.google.inject.AbstractModule;
import com.peterphi.std.guice.common.serviceprops.ConfigurationConverter;
import com.peterphi.std.io.PropertyFile;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Log4JModule
extends AbstractModule {
    private static Logger log = Logger.getLogger(Log4JModule.class);
    private Configuration guiceConfig;
    private String configFile;
    private MetricRegistry registry;

    public Log4JModule(Configuration configuration, MetricRegistry registry) {
        this.registry = registry;
        this.guiceConfig = configuration;
        this.configFile = configuration.getString("log4j.properties", null);
    }

    protected void configure() {
        if (this.configFile != null) {
            log.debug((Object)("Loading log4j configuration from " + this.configFile));
            Properties config = this.configFile.equals("embedded") ? ConfigurationConverter.toProperties(this.guiceConfig) : PropertyFile.find((String)this.configFile).toProperties();
            LogManager.resetConfiguration();
            PropertyConfigurator.configure((Properties)config);
        } else {
            log.debug((Object)"Leaving logging subsystem to initialise itself");
        }
        InstrumentedAppender log4jmetrics = new InstrumentedAppender(this.registry);
        log4jmetrics.activateOptions();
        LogManager.getRootLogger().addAppender((Appender)log4jmetrics);
    }
}

