/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.serviceprops;

import com.google.inject.Injector;
import com.peterphi.std.guice.common.serviceprops.ConfigurationProperty;
import com.peterphi.std.guice.common.serviceprops.ConfigurationPropertyBindingSite;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

public class ConfigurationPropertyRegistry {
    private static final Logger log = Logger.getLogger(ConfigurationPropertyRegistry.class);
    private final SortedMap<String, ConfigurationProperty> properties = new TreeMap<String, ConfigurationProperty>();
    private final Map<Class, WeakHashMap<Object, Void>> instances = new HashMap<Class, WeakHashMap<Object, Void>>();
    private final Configuration configuration;
    private final Configuration overrides;

    public ConfigurationPropertyRegistry(Configuration configuration, Configuration overrides) {
        this.configuration = configuration;
        this.overrides = overrides;
    }

    <T, O> void register(Class<O> owner, AtomicReference<Injector> injector, String name, Class<T> type, AnnotatedElement element) {
        this.register(new ConfigurationPropertyBindingSite<T, O>(this, injector, owner, name, type, element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T, O> void register(ConfigurationPropertyBindingSite<T, O> site) {
        SortedMap<String, ConfigurationProperty> sortedMap = this.properties;
        synchronized (sortedMap) {
            if (!this.properties.containsKey(site.getName())) {
                log.debug((Object)("Discovered new property: " + site.getName()));
                this.properties.put(site.getName(), new ConfigurationProperty(this, this.configuration, this.overrides, site.getName()));
            }
            log.trace((Object)("Discovered new binding for property " + site.getName() + " of type " + site.getType() + " in " + site.getOwner()));
            ((ConfigurationProperty)this.properties.get(site.getName())).add(site);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationProperty get(String name) {
        SortedMap<String, ConfigurationProperty> sortedMap = this.properties;
        synchronized (sortedMap) {
            return (ConfigurationProperty)this.properties.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ConfigurationProperty> getAll() {
        SortedMap<String, ConfigurationProperty> sortedMap = this.properties;
        synchronized (sortedMap) {
            return new ArrayList<ConfigurationProperty>(this.properties.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstance(Class<?> discoveredType, Object newlyConstructed) {
        WeakHashMap<Object, Void> map;
        Map<Class, WeakHashMap<Object, Void>> map2 = this.instances;
        synchronized (map2) {
            map = this.instances.get(discoveredType);
            if (map == null) {
                map = new WeakHashMap();
                this.instances.put(discoveredType, map);
            }
        }
        map2 = map;
        synchronized (map2) {
            map.put(newlyConstructed, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Iterable<Object> getInstances(Class type) {
        WeakHashMap<Object, Void> map;
        Map<Class, WeakHashMap<Object, Void>> map2 = this.instances;
        synchronized (map2) {
            map = this.instances.get(type);
        }
        if (map != null) {
            map2 = map;
            synchronized (map2) {
                return new ArrayList<Object>(map.keySet());
            }
        }
        return Collections.emptyList();
    }
}

