/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.archive.JarArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.PrefixFilter;

public class ClassScanner {
    private static final Logger log = Logger.getLogger(ClassScanner.class);
    private final AnnotationFinder finder;

    private ClassScanner(AnnotationFinder finder) {
        this.finder = finder;
    }

    public List<Class<?>> getClasses(String pkg, boolean recursive, Predicate<Class<?>> predicate) {
        return this.filter(this.finder.findClassesInPackage(pkg, recursive), predicate);
    }

    public List<Class<?>> getClasses(String pkg, boolean recursive) {
        return this.getClasses(pkg, recursive, null);
    }

    public List<Class<?>> getSiblingClasses(Class<?> clazz, boolean recursive, Predicate<Class<?>> predicate) {
        return this.getClasses(ClassScanner.getPackages(clazz)[0], recursive, predicate);
    }

    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        return this.filter(this.finder.findAnnotatedClasses(annotation), predicate);
    }

    public List<Class<?>> getAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getAnnotatedClasses(annotation, null);
    }

    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation, Predicate<Class<?>> predicate) {
        return this.filter(this.finder.findInheritedAnnotatedClasses(annotation), predicate);
    }

    public List<Class<?>> getInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
        return this.getInheritedAnnotatedClasses(annotation, null);
    }

    public <T> List<Class<? extends T>> getExtendingClasses(Class<T> clazz) {
        return this.getExtendingClasses(clazz, null);
    }

    public <T> List<Class<? extends T>> getExtendingClasses(Class<T> clazz, Predicate<Class<? extends T>> predicate) {
        return this.filter(this.finder.findImplementations(clazz), predicate);
    }

    private <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (predicate != null) {
            Iterator<T> it = list.iterator();
            while (it.hasNext()) {
                if (predicate.apply(it.next())) continue;
                it.remove();
            }
        }
        return list;
    }

    public static ClassScanner forPackages(String ... packages) {
        return ClassScanner.forPackages(Thread.currentThread().getContextClassLoader(), packages);
    }

    public static ClassScanner forPackages(Class<?> ... classes) {
        return ClassScanner.forPackages(ClassScanner.getPackages(classes));
    }

    public static ClassScanner forPackages(ClassLoader classloader, String ... packages) {
        CompositeArchive archive = ClassScanner.getArchivesForPackage(classloader, packages);
        AnnotationFinder finder = new AnnotationFinder((Archive)archive, true);
        return new ClassScanner(finder);
    }

    private static String[] getPackages(Class<?> ... classes) {
        HashSet<String> set = new HashSet<String>(classes.length);
        for (Class<?> clazz : classes) {
            set.add(clazz.getPackage().getName());
        }
        return set.toArray(new String[set.size()]);
    }

    private static CompositeArchive getArchivesForPackage(ClassLoader classloader, String ... packages) {
        try {
            ArrayList<Object> archives = new ArrayList<Object>();
            for (String pkg : packages) {
                if (!pkg.endsWith(".")) {
                    pkg = pkg + ".";
                }
                String baseFolder = pkg.replace('.', '/');
                Enumeration<URL> urls = classloader.getResources(baseFolder);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    log.info((Object)("Found source: " + url));
                    if (url.getProtocol() != null && (url.getProtocol().equals("zip") || url.getProtocol().equals("jar"))) {
                        archives.add(new FilteredArchive((Archive)new JarArchive(classloader, url), (Filter)new PrefixFilter(pkg)));
                        continue;
                    }
                    archives.add(new FileArchive(classloader, url, pkg));
                }
            }
            return new CompositeArchive(archives);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error loading archives for packages: " + Arrays.asList(packages), e);
        }
    }

    public static Predicate<Class<?>> annotatedWith(final Class<? extends Annotation> annotation) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isAnnotationPresent(annotation);
            }
        };
    }

    public static Predicate<Class<?>> packagePredicate(final Predicate<String> packagePredicate) {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return packagePredicate.apply((Object)input.getPackage().getName());
            }
        };
    }

    public static Predicate<Class<?>> interfaceClass() {
        return new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInterface();
            }
        };
    }
}

