/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.lifecycle;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.peterphi.std.guice.common.lifecycle.GuiceLifecycleListener;

public class GuiceLifecycleModule
extends AbstractModule {
    protected void configure() {
        TypeListener listener = new TypeListener(){

            public <I> void hear(TypeLiteral<I> typeLiteral, TypeEncounter<I> typeEncounter) {
                typeEncounter.register(new InjectionListener<I>(){

                    public void afterInjection(Object o) {
                        ((GuiceLifecycleListener)o).postConstruct();
                    }
                });
            }
        };
        this.bindListener((Matcher)new ImplementsGuiceLifecycleListener(), listener);
    }

    static class ImplementsGuiceLifecycleListener
    extends AbstractMatcher<TypeLiteral<?>> {
        public static final ImplementsGuiceLifecycleListener INSTANCE = new ImplementsGuiceLifecycleListener();

        ImplementsGuiceLifecycleListener() {
        }

        public boolean matches(TypeLiteral<?> tpe) {
            return GuiceLifecycleListener.class.isAssignableFrom(tpe.getRawType());
        }
    }
}

