/*
 * Decompiled with CFR 0.152.
 */
package com.peterphi.std.guice.common.retry.module;

import com.peterphi.std.threading.retry.Retryable;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.log4j.Logger;

final class InvocationRetryable
implements Retryable<Object> {
    private static final Logger log = Logger.getLogger(InvocationRetryable.class);
    final MethodInvocation invocation;
    final Class<? extends Throwable>[] alwaysRetry;
    final Class<? extends Throwable>[] noRetry;
    final Class<? extends Throwable>[] noRetryCore;

    public InvocationRetryable(MethodInvocation invocation, Class<? extends Throwable>[] alwaysRetry, Class<? extends Throwable>[] noRetry, Class<? extends Throwable>[] noRetryCore) {
        this.invocation = invocation;
        this.alwaysRetry = alwaysRetry;
        this.noRetry = noRetry;
        this.noRetryCore = noRetryCore;
    }

    public Object attempt(int attempt) throws Exception {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Invoking " + this.toString() + " for attempt #" + attempt));
            }
            return this.invocation.proceed();
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public boolean shouldRetry(int attempt, Throwable e) {
        for (Class<? extends Throwable> type : this.alwaysRetry) {
            if (!type.isInstance(e)) continue;
            return true;
        }
        for (Class<? extends Throwable> type : this.noRetry) {
            if (!type.isInstance(e)) continue;
            return false;
        }
        for (Class<? extends Throwable> type : this.noRetryCore) {
            if (!type.isInstance(e)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.invocation.getMethod().toString();
    }
}

