/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.server.cmd;

import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.common.base.P4ResultMapUtils;
import com.perforce.p4java.common.function.Function;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.cmd.BaseDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.server.KeyOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.delegator.IKeyDelegator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class KeyDelegator
extends BaseDelegator
implements IKeyDelegator {
    public KeyDelegator(IOptionsServer server) {
        super(server);
    }

    @Override
    public String deleteKey(String keyName) throws P4JavaException {
        Validate.notBlank((CharSequence)keyName, (String)"Key name shouldn't null or empty", (Object[])new Object[0]);
        return this.setKey(keyName, null, new KeyOptions(true, false));
    }

    @Override
    public String setKey(String keyName, String value, KeyOptions opts) throws P4JavaException {
        Validate.notBlank((CharSequence)keyName, (String)"Key name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEY, Parameters.processParameters((Options)opts, null, new String[]{keyName, value}, (IServer)this.server), null);
        return this.parseValueFromResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(map -> ResultMapParser.handleErrorStr(map)));
    }

    @Override
    public String getKey(String keyName) throws P4JavaException {
        Validate.notBlank((CharSequence)keyName, (String)"Key name shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEY, new String[]{keyName}, null);
        return this.parseValueFromResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(map -> ResultMapParser.handleErrorStr(map)));
    }

    private String parseValueFromResultMaps(List<Map<String, Object>> resultMaps, Function<Map<String, Object>, Boolean> construct) throws RequestException {
        if (Objects.nonNull(resultMaps)) {
            for (Map<String, Object> map : resultMaps) {
                if (!Objects.nonNull(map) || construct.apply(map).booleanValue() || !map.containsKey("value")) continue;
                return P4ResultMapUtils.parseString(map, "value");
            }
        }
        return "";
    }

    @Override
    public String setMultipleKeyValuePair(String[] pairs) throws P4JavaException {
        Validate.notEmpty((Object[])pairs, (String)"Key Value pairs shouldn't null or empty", (Object[])new Object[0]);
        List<Map<String, Object>> resultMaps = this.execMapCmdList(CmdSpec.KEY, Parameters.processParameters((Options)new KeyOptions().setMultiplePair(true), null, pairs, (IServer)this.server), null);
        return this.parseValueFromResultMaps(resultMaps, P4JavaExceptions.rethrowFunction(map -> ResultMapParser.handleErrorStr(map)));
    }
}

