/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.rpc.handles;

import com.perforce.p4java.client.ClientProgressReport;
import com.perforce.p4java.diff.DigestTree;
import com.perforce.p4java.diff.StrStr;
import com.perforce.p4java.impl.mapbased.rpc.CommandEnv;
import com.perforce.p4java.impl.mapbased.rpc.handles.AbstractHandle;
import com.perforce.p4java.server.callback.progress.IProgress;
import com.perforce.p4java.server.callback.progress.ProgressType;
import com.perforce.p4java.server.callback.progress.ProgressUnit;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ReconcileHandle
extends AbstractHandle {
    private static final String RECONCILE_HANDLER_SKIP_ADD_KEY = "skipAdd";
    private static final String RECONCILE_DEL_COUNT_KEY = "delCount";
    private final Set<Integer> matchedIndex = new HashSet<Integer>();
    private final DigestTree digestTree = new DigestTree();
    private ClientProgressReport progressReport = null;
    private String stage = "";

    public ClientProgressReport getProgressReport() {
        return this.progressReport;
    }

    public ReconcileHandle(CommandEnv.RpcHandler rpcHandler) {
        super(rpcHandler);
    }

    @Override
    public String getHandleType() {
        return "ReconcileHandle";
    }

    public List<String> getSkipFiles() {
        if (!this.rpcHandler.getMap().containsKey(RECONCILE_HANDLER_SKIP_ADD_KEY)) {
            LinkedList<String> list = new LinkedList<String>();
            this.rpcHandler.getMap().put(RECONCILE_HANDLER_SKIP_ADD_KEY, list);
            return list;
        }
        return (List)this.rpcHandler.getMap().get(RECONCILE_HANDLER_SKIP_ADD_KEY);
    }

    public void incrementDelCount() {
        long delCount = 0L;
        if (this.rpcHandler.getMap().containsKey(RECONCILE_DEL_COUNT_KEY)) {
            delCount = (Long)this.rpcHandler.getMap().get(RECONCILE_DEL_COUNT_KEY);
        }
        this.rpcHandler.getMap().put(RECONCILE_DEL_COUNT_KEY, ++delCount);
    }

    public long getDelCount() {
        if (this.rpcHandler.getMap().containsKey(RECONCILE_DEL_COUNT_KEY)) {
            return (Long)this.rpcHandler.getMap().get(RECONCILE_DEL_COUNT_KEY);
        }
        return 0L;
    }

    public void setMatch(int i) {
        this.matchedIndex.add(i);
    }

    public boolean alreadyMatched(int i) {
        return this.matchedIndex.contains(i);
    }

    public String getDigest(String fileName, String digestStr) {
        this.digestTree.putIfAbsent(new StrStr(fileName, digestStr));
        return this.digestTree.get(fileName).getDigest();
    }

    public DigestTree getDigestTree() {
        return this.digestTree;
    }

    public void beginStage(String stage, IProgress progressCallback, ProgressType progressType) {
        this.stage = stage;
        if (progressCallback != null) {
            progressCallback.init(progressType);
            this.progressReport = new ClientProgressReport(progressCallback);
            this.progressReport.description(stage);
            if (ProgressType.FILES.equals((Object)progressType)) {
                this.progressReport.units(ProgressUnit.FILES);
            }
            if (ProgressType.DIRS.equals((Object)progressType)) {
                this.progressReport.units(ProgressUnit.DIRS);
            }
            this.progressReport.doReport(0);
        }
    }

    public void stageComplete() {
        if (this.progressReport == null) {
            return;
        }
        this.progressReport.doReport(1);
    }

    public void increment(long inc) {
        if (this.progressReport == null) {
            return;
        }
        this.progressReport.increment(inc);
        if (this.progressReport.isComplete()) {
            this.stageComplete();
        }
    }
}

