/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.diff;

import com.perforce.p4java.diff.DiffAnalyze;
import com.perforce.p4java.diff.DiffFlags;
import com.perforce.p4java.diff.Sequence;
import com.perforce.p4java.diff.Snake;
import com.perforce.p4java.exception.FileEncoderException;
import com.perforce.p4java.impl.mapbased.rpc.sys.RpcPerforceFile;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;

public class Diff {
    private Sequence spx = null;
    private Sequence spy = null;
    private PrintWriter out = null;
    private DiffAnalyze diff = null;
    private DiffFlags flags = null;
    private boolean closeOut = false;
    private final Sequence.LineType lineType = Sequence.LineType.LineTypeRaw;
    private final String newLines = System.lineSeparator();
    private int fastMaxD = 0;
    private int chunkCnt = 0;

    public void SetInput(RpcPerforceFile f1, Charset c1, RpcPerforceFile f2, Charset c2, DiffFlags flags) throws FileEncoderException, IOException {
        this.spx = new Sequence(f1, c1, flags);
        this.flags = flags;
        this.spy = new Sequence(f2, c2, flags);
        this.diff = new DiffAnalyze(this.spx, this.spy, this.fastMaxD);
    }

    public void SetOutput(OutputStream o) {
        this.out = new PrintWriter(o);
        this.closeOut = true;
    }

    public void CloseOutput() throws IOException {
        if (this.closeOut) {
            this.out.close();
        }
        this.closeOut = false;
    }

    public void DiffWithFlags(DiffFlags flags) throws IOException, FileEncoderException {
        switch (flags.type) {
            case Normal: {
                this.DiffNorm();
                break;
            }
            case Context: {
                this.DiffContext(flags.contextCount);
                break;
            }
            case Unified: {
                this.DiffUnified(flags.contextCount);
                break;
            }
            case Summary: {
                this.DiffSummary();
                break;
            }
            case HTML: {
                this.DiffHTML();
                break;
            }
            case Rcs: {
                this.DiffRcs();
            }
        }
    }

    public void DiffContext(int c) throws IOException, FileEncoderException {
        Snake t;
        if (c < 0) {
            c = 3;
        }
        Snake s = this.diff.GetSnake();
        while ((t = s.next) != null) {
            String mark;
            Snake tt;
            while (t.next != null && t.x.get() + 2 * c >= t.u.get()) {
                t = t.next;
            }
            int sx = s.u.get() - c > 0 ? s.u.get() - c : 0;
            int sy = s.v.get() - c > 0 ? s.v.get() - c : 0;
            int ex = t.x.get() + c < this.spx.Lines() ? t.x.get() + c : this.spx.Lines();
            int ey = t.y.get() + c < this.spy.Lines() ? t.y.get() + c : this.spy.Lines();
            this.out.printf("***************%s", this.newLines);
            this.out.printf("*** %d,%d ****%s", sx + 1, ex, this.newLines);
            Snake ss = s;
            while (ss != t) {
                tt = ss.next;
                if (ss.u.get() < tt.x.get()) {
                    this.Walker("  ", this.spx, sx, ss.u.get());
                    mark = ss.v.get() < tt.y.get() ? "! " : "- ";
                    this.Walker(mark, this.spx, ss.u.get(), tt.x.get());
                    sx = tt.x.get();
                }
                ss = tt;
            }
            if (s.u.get() < sx) {
                this.Walker("  ", this.spx, sx, ex);
            }
            this.out.printf("--- %d,%d ----%s", sy + 1, ey, this.newLines);
            ss = s;
            while (ss != t) {
                tt = ss.next;
                if (ss.v.get() < tt.y.get()) {
                    this.Walker("  ", this.spy, sy, ss.v.get());
                    mark = ss.u.get() < tt.x.get() ? "! " : "+ ";
                    this.Walker(mark, this.spy, ss.v.get(), tt.y.get());
                    sy = tt.y.get();
                }
                ss = tt;
            }
            if (s.v.get() < sy) {
                this.Walker("  ", this.spy, sy, ey);
            }
            s = t;
        }
    }

    public void DiffUnified(int c) throws IOException, FileEncoderException {
        Snake t;
        if (c < 0) {
            c = 3;
        }
        Snake s = this.diff.GetSnake();
        while ((t = s.next) != null) {
            while (t.next != null && t.x.get() + 2 * c >= t.u.get()) {
                t = t.next;
            }
            int sx = s.u.get() - c > 0 ? s.u.get() - c : 0;
            int sy = s.v.get() - c > 0 ? s.v.get() - c : 0;
            int ex = t.x.get() + c < this.spx.Lines() ? t.x.get() + c : this.spx.Lines();
            int ey = t.y.get() + c < this.spy.Lines() ? t.y.get() + c : this.spy.Lines();
            this.out.printf("@@ -%d,%d +%d,%d @@%s", sx + 1, ex - sx, sy + 1, ey - sy, this.newLines);
            do {
                int nx = s.u.get();
                int ny = s.v.get();
                this.Walker(" ", this.spx, sx, nx);
                s = s.next;
                sx = s.x.get();
                sy = s.y.get();
                this.Walker("-", this.spx, nx, sx);
                this.Walker("+", this.spy, ny, sy);
            } while (s != t);
            this.Walker(" ", this.spx, sx, ex);
        }
    }

    public void DiffNorm() throws IOException, FileEncoderException {
        Snake t;
        Snake s = this.diff.GetSnake();
        while ((t = s.next) != null) {
            block10: {
                char c;
                int ny;
                int nx;
                block8: {
                    block9: {
                        block7: {
                            nx = s.u.get();
                            ny = s.v.get();
                            if (s.u.get() >= t.x.get() || s.v.get() >= t.y.get()) break block7;
                            c = 'c';
                            ++nx;
                            ++ny;
                            break block8;
                        }
                        if (s.u.get() >= t.x.get()) break block9;
                        c = 'd';
                        ++nx;
                        break block8;
                    }
                    if (s.v.get() >= t.y.get()) break block10;
                    c = 'a';
                    ++ny;
                }
                this.out.printf("%d", nx);
                if (t.x.get() > nx) {
                    this.out.printf(",%d", t.x.get());
                }
                this.out.printf("%c%d", Character.valueOf(c), ny);
                if (t.y.get() > ny) {
                    this.out.printf(",%d", t.y.get());
                }
                this.out.printf("%s", this.newLines);
                this.Walker("< ", this.spx, s.u.get(), t.x.get());
                if (c == 'c') {
                    this.out.printf("---%s", this.newLines);
                }
                this.Walker("> ", this.spy, s.v.get(), t.y.get());
            }
            s = t;
        }
    }

    public void DiffRcs() throws IOException, FileEncoderException {
        Snake t;
        Snake s = this.diff.GetSnake();
        while ((t = s.next) != null) {
            if (s.u.get() < t.x.get()) {
                this.out.printf("d%d %d%s", s.u.get() + 1, t.x.get() - s.u.get(), this.newLines);
                ++this.chunkCnt;
            }
            if (s.v.get() < t.y.get()) {
                this.out.printf("a%d %d%s", t.x.get(), t.y.get() - s.v.get(), this.newLines);
                ++this.chunkCnt;
                this.spy.SeekLine(s.v.get());
                this.spy.Dump(this.out, s.v, t.y.get(), this.lineType);
            }
            s = t;
        }
    }

    public void DiffHTML() throws IOException, FileEncoderException {
        Snake t;
        Snake s = this.diff.GetSnake();
        while ((t = s.next) != null) {
            this.spx.SeekLine(s.x.get());
            this.spy.SeekLine(s.v.get());
            this.spx.Dump(this.out, s.x, s.u.get(), this.lineType);
            this.out.printf("<font color=red>", new Object[0]);
            this.spx.Dump(this.out, s.u, t.x.get(), this.lineType);
            this.out.printf("</font><font color=blue>", new Object[0]);
            this.spy.Dump(this.out, s.v, t.y.get(), this.lineType);
            this.out.printf("</font>", new Object[0]);
            s = t;
        }
    }

    public void DiffSummary() {
        Snake t;
        Snake s = this.diff.GetSnake();
        int l_deleted = 0;
        int l_added = 0;
        int l_edited_in = 0;
        int l_edited_out = 0;
        int c_deleted = 0;
        int c_added = 0;
        int c_edited = 0;
        while ((t = s.next) != null) {
            if (s.u.get() < t.x.get() && s.v.get() < t.y.get()) {
                l_edited_in += t.x.get() - s.u.get();
                l_edited_out += t.y.get() - s.v.get();
                ++c_edited;
            } else if (s.v.get() < t.y.get()) {
                l_added += t.y.get() - s.v.get();
                ++c_added;
            } else if (s.u.get() < t.x.get()) {
                l_deleted += t.x.get() - s.u.get();
                ++c_deleted;
            }
            s = t;
        }
        this.out.printf("add %d chunks %d lines%sdeleted %d chunks %d lines%schanged %d chunks %d / %d lines%s", c_added, l_added, this.newLines, c_deleted, l_deleted, this.newLines, c_edited, l_edited_in, l_edited_out, this.newLines);
    }

    public void DiffFast() {
        this.fastMaxD = 1;
    }

    public int GetChunkCnt() {
        return this.chunkCnt;
    }

    public boolean IsIdentical() {
        boolean retval = this.diff != null && this.diff.GetSnake() != null && this.diff.GetSnake().next == null;
        return retval;
    }

    private void Walker(String mark, Sequence s, int sx, int ex) throws IOException, FileEncoderException {
        s.SeekLine(sx);
        boolean lineEnd = true;
        while (sx < ex) {
            this.out.print(mark);
            lineEnd = s.Dump(this.out, new AtomicInteger(sx), sx + 1, this.lineType);
            ++sx;
        }
        if (!lineEnd && this.flags.type == DiffFlags.Type.Unified) {
            this.out.printf("%s\\ No newline at end of file%s", this.newLines, this.newLines);
        }
    }
}

