/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.client;

import com.perforce.p4java.client.BaseProgressReport;
import com.perforce.p4java.server.callback.progress.IProgress;

public class ClientProgressReport
extends BaseProgressReport {
    protected IProgress cp;

    public ClientProgressReport(IProgress cp) {
        if (cp == null) {
            throw new IllegalArgumentException("ClientProgress cannot be null");
        }
        this.cp = cp;
    }

    @Override
    public void doReport(int flag) {
        if (this.cp == null) {
            return;
        }
        if (this.descriptionChanged || this.unitsChanged) {
            this.cp.description(this.description, this.units);
        }
        if (this.totalChanged) {
            this.cp.total(this.total);
        }
        if (this.positionChanged) {
            this.cp.update(this.position);
        }
        this.clearChangeFlags();
        if (flag == 1 || flag == 2) {
            if (flag == 2) {
                this.cp.done(1);
            } else {
                this.cp.done(0);
            }
            this.needFinal = false;
        }
    }

    public IProgress getClientProgress() {
        return this.cp;
    }

    public void close() {
        if (this.needFinal) {
            this.doReport(2);
        }
    }

    @Override
    public boolean isComplete() {
        return this.total > 0L && this.position == this.total;
    }

    @Override
    protected void finalize() throws Throwable {
        try {
            if (this.needFinal) {
                this.doReport(2);
            }
        }
        finally {
            super.finalize();
        }
    }
}

