/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.impl.mapbased.client;

import com.perforce.p4java.Log;
import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.client.delegator.IWhereDelegator;
import com.perforce.p4java.common.base.P4JavaExceptions;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IRepo;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.core.file.IntegrationOptions;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.ConnectionException;
import com.perforce.p4java.exception.NullPointerError;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.exception.RequestException;
import com.perforce.p4java.impl.generic.client.ClientView;
import com.perforce.p4java.impl.generic.core.InputMapper;
import com.perforce.p4java.impl.generic.core.ListData;
import com.perforce.p4java.impl.generic.core.MapEntry;
import com.perforce.p4java.impl.mapbased.client.ClientSummary;
import com.perforce.p4java.impl.mapbased.client.ViewDepotType;
import com.perforce.p4java.impl.mapbased.client.cmd.WhereDelegator;
import com.perforce.p4java.impl.mapbased.rpc.RpcServer;
import com.perforce.p4java.impl.mapbased.rpc.func.client.ClientHelper;
import com.perforce.p4java.impl.mapbased.server.Parameters;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.impl.mapbased.server.cmd.ListDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ReposDelegator;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultListBuilder;
import com.perforce.p4java.impl.mapbased.server.cmd.ResultMapParser;
import com.perforce.p4java.option.Options;
import com.perforce.p4java.option.client.AddFilesOptions;
import com.perforce.p4java.option.client.CopyFilesOptions;
import com.perforce.p4java.option.client.DeleteFilesOptions;
import com.perforce.p4java.option.client.EditFilesOptions;
import com.perforce.p4java.option.client.GetDiffFilesOptions;
import com.perforce.p4java.option.client.IntegrateFilesOptions;
import com.perforce.p4java.option.client.LabelSyncOptions;
import com.perforce.p4java.option.client.LockFilesOptions;
import com.perforce.p4java.option.client.MergeFilesOptions;
import com.perforce.p4java.option.client.ParallelSyncOptions;
import com.perforce.p4java.option.client.PopulateFilesOptions;
import com.perforce.p4java.option.client.ReconcileFilesOptions;
import com.perforce.p4java.option.client.ReopenFilesOptions;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.p4java.option.client.ResolvedFilesOptions;
import com.perforce.p4java.option.client.RevertFilesOptions;
import com.perforce.p4java.option.client.ShelveFilesOptions;
import com.perforce.p4java.option.client.SyncOptions;
import com.perforce.p4java.option.client.UndoFilesOptions;
import com.perforce.p4java.option.client.UnlockFilesOptions;
import com.perforce.p4java.option.client.UnshelveFilesOptions;
import com.perforce.p4java.option.server.ListOptions;
import com.perforce.p4java.option.server.OpenedFilesOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Client
extends ClientSummary
implements IClient {
    public static final String MERGE_TMP_FILENAME_KEY = "P4JMergeTmpFile";
    public static final String MERGE_START_FROM_REV_KEY = "P4JMergeStartFromRev";
    public static final String MERGE_END_FROM_REV_KEY = "P4JMergeEndFromRev";
    public static final String DEFAULT_DESCRIPTION = "New Client created by P4Java";
    private Server serverImpl = null;
    private ClientView clientView = null;
    private ArrayList<String> changeView = null;
    private ViewDepotType viewDepotType;
    private IWhereDelegator whereDelegator = null;

    public static Client newClient(IOptionsServer server, String name, String description, String root, String[] paths) {
        String rootDir = root;
        Server serverImpl = null;
        String userName = null;
        if (server == null) {
            throw new NullPointerError("null server passed to Client.newClient");
        }
        if (name == null) {
            throw new NullPointerError("null client name passed to Client.newClient");
        }
        if (!(server instanceof Server)) {
            throw new P4JavaError("IOptionsServer passed to Client.newClient does not implement 'Server' class");
        }
        serverImpl = (Server)server;
        if (rootDir == null) {
            String string = rootDir = serverImpl.getWorkingDirectory() == null ? System.getProperty("user.dir") : serverImpl.getWorkingDirectory();
            if (rootDir == null) {
                throw new P4JavaError("unable to determine root directory for new client");
            }
        }
        userName = server.getUserName();
        if (paths == null) {
            paths = new String[]{"//depot/... //" + name + "/depot/..."};
        }
        Client client = new Client(server);
        client.setName(name);
        client.setDescription(description == null ? DEFAULT_DESCRIPTION : description);
        client.setOwnerName(userName);
        client.setRoot(rootDir);
        ClientView clientView = new ClientView();
        clientView.setClient(client);
        ArrayList<ClientView.ClientViewMapping> viewMappings = new ArrayList<ClientView.ClientViewMapping>();
        int i = 0;
        for (String mapping : paths) {
            if (mapping == null) {
                throw new NullPointerError("null mapping string passed to Client.newClient");
            }
            viewMappings.add(new ClientView.ClientViewMapping(i, mapping));
            ++i;
        }
        clientView.setEntryList(viewMappings);
        client.setClientView(clientView);
        return client;
    }

    @Deprecated
    public Client() {
        this.refreshable = true;
        this.updateable = true;
    }

    public Client(IServer server) {
        this.refreshable = true;
        this.updateable = true;
        this.setServer(server);
    }

    public Client(String name, Date accessed, Date updated, String description, String hostName, String ownerName, String root, IClientSummary.ClientLineEnd lineEnd, IClientSummary.IClientOptions options, IClientSummary.IClientSubmitOptions submitOptions, List<String> alternateRoots, IServer serverImpl, ClientView clientView) {
        super(name, accessed, updated, description, hostName, ownerName, root, lineEnd, options, submitOptions, alternateRoots);
        this.setServer(serverImpl);
        this.clientView = clientView;
    }

    public Client(String name, Date accessed, Date updated, String description, String hostName, String ownerName, String root, IClientSummary.ClientLineEnd lineEnd, IClientSummary.IClientOptions options, IClientSummary.IClientSubmitOptions submitOptions, List<String> alternateRoots, IServer serverImpl, ClientView clientView, String stream, String type) {
        super(name, accessed, updated, description, hostName, ownerName, root, lineEnd, options, submitOptions, alternateRoots, stream, type);
        this.setServer(serverImpl);
        this.clientView = clientView;
    }

    public Client(IServer serverImpl, Map<String, Object> map) {
        super(map, false);
        this.refreshable = true;
        this.updateable = true;
        this.setServer(serverImpl);
        this.viewDepotType = ViewDepotType.LOCAL;
        if (map != null) {
            this.name = (String)map.get("Client");
            ClientView viewImpl = new ClientView();
            ArrayList<ClientView.ClientViewMapping> mappingList = new ArrayList<ClientView.ClientViewMapping>();
            viewImpl.setEntryList(mappingList);
            this.clientView = viewImpl;
            String pfx = "View";
            String commentPfx = "ViewComment";
            int i = 0;
            while (map.containsKey(pfx + i) || map.containsKey(commentPfx + i)) {
                String key = pfx + i;
                String commentKey = commentPfx + i;
                String[] parts = MapEntry.parseViewMappingString((String)map.get(key));
                String comment = MapEntry.parseComments((String)map.get(commentKey));
                if (parts.length < 2 && StringUtils.isEmpty((CharSequence)comment)) {
                    throw new P4JavaError("bad client view mapping string in Client constructor: " + map.get(key));
                }
                ClientView.ClientViewMapping mapping = new ClientView.ClientViewMapping(i, parts[0], parts[1]);
                mapping.setComment(comment);
                mappingList.add(mapping);
                ++i;
            }
            ArrayList<String> changeViewImpl = new ArrayList<String>();
            pfx = "ChangeView";
            int i2 = 0;
            while (map.containsKey(pfx + i2)) {
                String key = pfx + i2;
                String changeEntry = (String)map.get(key);
                if (changeEntry == null || changeEntry.isEmpty()) {
                    throw new P4JavaError("null or empty change view mapping string in Client constructor.");
                }
                changeViewImpl.add(changeEntry);
                ++i2;
            }
            this.changeView = changeViewImpl;
            this.description = (String)map.get("Description");
            if (this.description != null && this.description.length() > 1 && this.description.endsWith("\n")) {
                this.description = this.description.substring(0, this.description.length() - 1);
            }
            try {
                if (map.get("Access") != null) {
                    this.accessed = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Access"));
                }
            }
            catch (Exception exc) {
                Log.error("Access date parse error in Client constructor " + exc.getLocalizedMessage(), new Object[0]);
                Log.exception(exc);
            }
            try {
                if (map.get("Update") != null) {
                    this.updated = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse((String)map.get("Update"));
                }
            }
            catch (Exception exc) {
                Log.error("Update date parse error in Client constructor " + exc.getLocalizedMessage(), new Object[0]);
                Log.exception(exc);
            }
            viewImpl.setClient(this);
            if (map.get("ViewDepotType") != null) {
                this.viewDepotType = ViewDepotType.fromString(map.get("ViewDepotType").toString());
            }
        }
    }

    public Client(IClientSummary clientSummary, boolean refresh) throws ConnectionException, RequestException, AccessException {
        this(clientSummary, null, refresh);
    }

    public Client(IClientSummary clientSummary, IServer serverImpl, boolean refresh) throws ConnectionException, RequestException, AccessException {
        super(false);
        this.setServer(serverImpl);
        if (clientSummary != null) {
            if (refresh) {
                if (clientSummary.getName() == null) {
                    throw new NullPointerError("Null label name in client summary object passed to Client constructor");
                }
                this.name = clientSummary.getName();
                this.refresh();
            } else {
                this.name = clientSummary.getName();
                this.accessed = clientSummary.getAccessed();
                this.updated = clientSummary.getUpdated();
                this.description = clientSummary.getDescription();
                this.hostName = clientSummary.getHostName();
                this.ownerName = clientSummary.getOwnerName();
                this.root = clientSummary.getRoot();
                this.lineEnd = clientSummary.getLineEnd();
                this.options = clientSummary.getOptions();
                this.submitOptions = clientSummary.getSubmitOptions();
                this.alternateRoots = clientSummary.getAlternateRoots();
                this.stream = clientSummary.getStream();
                this.serverId = clientSummary.getServerId();
            }
        }
    }

    private void init(IServer serverImpl) {
        this.whereDelegator = new WhereDelegator(serverImpl, this);
    }

    @Override
    public IServer getServer() {
        return this.serverImpl;
    }

    @Override
    public void complete() throws ConnectionException, RequestException, AccessException {
    }

    @Override
    public void refresh() throws ConnectionException, RequestException, AccessException {
        IClient refreshedClient;
        Server refreshServer = this.serverImpl;
        String refreshName = null;
        refreshName = this.getName();
        if (refreshServer != null && refreshName != null && (refreshedClient = refreshServer.getClient(refreshName)) != null) {
            this.setName(refreshName);
            this.setAccessed(refreshedClient.getAccessed());
            this.setUpdated(refreshedClient.getUpdated());
            this.setAlternateRoots(refreshedClient.getAlternateRoots());
            this.setClientView(refreshedClient.getClientView());
            this.setChangeView(refreshedClient.getChangeView());
            this.setDescription(refreshedClient.getDescription());
            this.setHostName(refreshedClient.getHostName());
            this.setLineEnd(refreshedClient.getLineEnd());
            this.setOptions(refreshedClient.getOptions());
            this.setOwnerName(refreshedClient.getOwnerName());
            this.setRoot(refreshedClient.getRoot());
            this.setSubmitOptions(refreshedClient.getSubmitOptions());
            this.setUpdated(refreshedClient.getUpdated());
            this.setStream(refreshedClient.getStream());
            this.setServerId(refreshedClient.getServerId());
            this.setType(refreshedClient.getType());
        }
    }

    @Override
    public void update() throws ConnectionException, RequestException, AccessException {
        if (this.serverImpl == null) {
            throw new NullPointerError("Attempted to update client with no associated server set on client");
        }
        this.serverImpl.updateClient(this);
    }

    @Override
    public void update(boolean force) throws ConnectionException, RequestException, AccessException {
        if (this.serverImpl == null) {
            throw new NullPointerError("Attempted to update client with no associated server set on client");
        }
        this.serverImpl.updateClient((IClient)this, force);
    }

    @Override
    public ClientView getClientView() {
        return this.clientView;
    }

    @Override
    public void setClientView(ClientView clientView) {
        this.clientView = clientView;
    }

    @Override
    public ArrayList<String> getChangeView() {
        return this.changeView;
    }

    @Override
    public void setChangeView(ArrayList<String> changeView) {
        this.changeView = changeView;
    }

    @Override
    public void setServer(IServer server) {
        this.serverImpl = (Server)server;
        this.init(server);
    }

    @Override
    public List<IFileSpec> sync(List<IFileSpec> fileSpecs, boolean forceUpdate, boolean noUpdate, boolean clientBypass, boolean serverBypass) throws ConnectionException, RequestException, AccessException {
        try {
            return this.sync(fileSpecs, new SyncOptions(forceUpdate, noUpdate, clientBypass, serverBypass));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> sync(List<IFileSpec> fileSpecs, SyncOptions syncOpts) throws P4JavaException {
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            throw new RequestException("Attempted to sync a client that is not the server's current client");
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.SYNC, Parameters.processParameters(syncOpts, fileSpecs, this.server), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                specList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return specList;
    }

    @Override
    public List<IFileSpec> syncParallel(List<IFileSpec> fileSpecs, SyncOptions syncOpts, ParallelSyncOptions pSyncOpts) throws P4JavaException {
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            throw new RequestException("Attempted to sync a client that is not the server's current client");
        }
        String[] syncOptions = ClientHelper.buildParallelOptions(this.serverImpl, fileSpecs, syncOpts, pSyncOpts);
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.SYNC.toString(), syncOptions, null, pSyncOpts.getCallback());
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                specList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return specList;
    }

    @Override
    public void sync(List<IFileSpec> fileSpecs, SyncOptions syncOpts, IStreamingCallback callback, int key) throws P4JavaException {
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            throw new RequestException("Attempted to sync a client that is not the server's current client");
        }
        this.serverImpl.execStreamingMapCommand(CmdSpec.SYNC.toString(), Parameters.processParameters(syncOpts, fileSpecs, this.server), null, callback, key);
    }

    @Override
    public void syncParallel(List<IFileSpec> fileSpecs, SyncOptions syncOpts, IStreamingCallback callback, int key, ParallelSyncOptions pSyncOpts) throws P4JavaException {
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            throw new RequestException("Attempted to sync a client that is not the server's current client");
        }
        String[] syncOptions = ClientHelper.buildParallelOptions(this.serverImpl, fileSpecs, syncOpts, pSyncOpts);
        this.serverImpl.execStreamingMapCommand(CmdSpec.SYNC.toString(), syncOptions, null, callback, key, pSyncOpts.getCallback());
    }

    @Override
    public List<IFileSpec> labelSync(List<IFileSpec> fileSpecs, String labelName, boolean noUpdate, boolean addFiles, boolean deleteFiles) throws ConnectionException, RequestException, AccessException {
        try {
            return this.labelSync(fileSpecs, labelName, new LabelSyncOptions(noUpdate, addFiles, deleteFiles));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> labelSync(List<IFileSpec> fileSpecs, String labelName, LabelSyncOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> specList = new ArrayList<IFileSpec>();
        if (labelName == null) {
            throw new NullPointerError("null label name passed to Client.labelSync()");
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.LABELSYNC, Parameters.processParameters((Options)opts, fileSpecs, "-l" + labelName, this.server), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                specList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return specList;
    }

    @Override
    public IChangelist createChangelist(IChangelist newChangelist) throws ConnectionException, RequestException, AccessException {
        if (this.getName() == null) {
            throw new NullPointerError("Null client name in newChangelist method call");
        }
        if (newChangelist == null) {
            throw new NullPointerError("Null new change list specification in newChangelist method call");
        }
        if (newChangelist.getId() != -1) {
            throw new RequestException("New changelist ID must be set to IChangelist.UNKNOWN");
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.CHANGE, new String[]{"-i"}, InputMapper.map(newChangelist));
        if (resultMaps != null) {
            int id = -1;
            for (Map<String, Object> map : resultMaps) {
                if (!ResultMapParser.handleErrorStr(map)) {
                    if (map.containsKey("change")) {
                        int i;
                        String changeStr = (String)map.get("change");
                        if (changeStr != null && (i = changeStr.indexOf(" ")) > 0 && i < changeStr.length()) {
                            try {
                                id = new Integer(changeStr.substring(i + 1));
                            }
                            catch (Exception exc) {
                                Log.error("Unexpected exception in Client.newChangelist: " + exc.getLocalizedMessage(), new Object[0]);
                                Log.exception(exc);
                            }
                        }
                    } else {
                        String[] strs;
                        String infoStr = ResultMapParser.getInfoStr(map);
                        if (infoStr != null && infoStr.contains("Change ") && infoStr.contains(" created") && (strs = infoStr.split(" ")).length >= 3 && strs[1] != null) {
                            id = -1;
                            try {
                                id = new Integer(strs[1]);
                            }
                            catch (Exception exc) {
                                Log.error("Unexpected exception in Client.newChangelist: " + exc.getLocalizedMessage(), new Object[0]);
                                Log.exception(exc);
                            }
                        }
                    }
                }
                if (id == -1) continue;
                return this.serverImpl.getChangelist(id);
            }
        }
        return null;
    }

    @Override
    public List<IFileSpec> addFiles(List<IFileSpec> fileSpecs, boolean noUpdate, int changeListId, String fileType, boolean useWildcards) throws ConnectionException, AccessException {
        try {
            return this.addFiles(fileSpecs, new AddFilesOptions(noUpdate, changeListId, fileType, useWildcards));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.addFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> addFiles(List<IFileSpec> fileSpecs, AddFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.ADD, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> deleteFiles(List<IFileSpec> fileSpecs, int changeListId, boolean noUpdate) throws ConnectionException, AccessException {
        try {
            return this.deleteFiles(fileSpecs, new DeleteFilesOptions(changeListId, noUpdate, false));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.deleteFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> deleteFiles(List<IFileSpec> fileSpecs, DeleteFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.DELETE, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> editFiles(List<IFileSpec> fileSpecs, boolean noUpdate, boolean bypassClientUpdate, int changeListId, String fileType) throws RequestException, ConnectionException, AccessException {
        int MINIMUM_OPTION_K_SERVER_VERSION = 20092;
        if (bypassClientUpdate && this.serverImpl.getServerVersionNumber() < 20092) {
            throw new RequestException("edit option 'bypassClientUpdate' only supported on servers 2009.2 and later");
        }
        try {
            return this.editFiles(fileSpecs, new EditFilesOptions(noUpdate, bypassClientUpdate, changeListId, fileType));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (RequestException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            throw new RequestException(exc.getMessage(), exc);
        }
    }

    @Override
    public List<IFileSpec> editFiles(List<IFileSpec> fileSpecs, EditFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.EDIT, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> revertFiles(List<IFileSpec> fileSpecs, boolean noUpdate, int changeListId, boolean revertOnlyUnchanged, boolean noRefresh) throws ConnectionException, AccessException {
        try {
            return this.revertFiles(fileSpecs, new RevertFilesOptions(noUpdate, changeListId, revertOnlyUnchanged, noRefresh));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.revertFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> revertFiles(List<IFileSpec> fileSpecs, RevertFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.REVERT, Parameters.processParameters((Options)opts, fileSpecs, null, false, (IServer)this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> undoFiles(List<IFileSpec> fileSpecs, int changelistId, boolean listOnly) throws ConnectionException, AccessException {
        try {
            UndoFilesOptions undoFilesOptions = new UndoFilesOptions(listOnly, changelistId);
            return this.undoFiles(fileSpecs, undoFilesOptions);
        }
        catch (AccessException | ConnectionException e) {
            throw e;
        }
        catch (P4JavaException e) {
            Log.warn("Unexpected exception in IServer.undoFiles: %s", e);
            return Collections.emptyList();
        }
    }

    @Override
    public List<IFileSpec> undoFiles(List<IFileSpec> fileSpecs, UndoFilesOptions opts) throws P4JavaException {
        P4JavaExceptions.throwRequestExceptionIfPerforceServerVersionOldThanExpected(this.serverImpl.getServerVersion() >= 20162, "command requires a Perforce server version 2016.2 or later", new Object[0]);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        boolean annotateFiles = false;
        for (IFileSpec fileSpec : fileSpecs) {
            if (fileSpec == null || fileSpec.getLabel() == null) continue;
            annotateFiles = true;
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.UNDO, Parameters.processParameters((Options)opts, fileSpecs, null, annotateFiles, (IServer)this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> haveList(List<IFileSpec> fileSpecs) throws ConnectionException, AccessException {
        return this.haveList(fileSpecs, null);
    }

    @Override
    public List<IFileSpec> graphHaveList(List<IFileSpec> fileSpecs) throws ConnectionException, AccessException {
        return this.haveList(fileSpecs, new String[]{"--graph-only"});
    }

    private List<IFileSpec> haveList(List<IFileSpec> fileSpecs, String[] filter) throws ConnectionException, AccessException {
        ArrayList<IFileSpec> haveList = new ArrayList<IFileSpec>();
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            return haveList;
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.HAVE, Server.getPreferredPathArray(filter, fileSpecs), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                haveList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return haveList;
    }

    @Override
    public List<IFileSpec> reopenFiles(List<IFileSpec> fileSpecs, int changeListId, String fileType) throws ConnectionException, AccessException {
        try {
            return this.reopenFiles(fileSpecs, new ReopenFilesOptions().setChangelistId(changeListId).setFileType(fileType));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.reopenFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> reopenFiles(List<IFileSpec> fileSpecs, ReopenFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> reopenList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.REOPEN, Parameters.processParameters((Options)opts, fileSpecs, null, false, (IServer)this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                reopenList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return reopenList;
    }

    @Override
    public List<IFileSpec> where(List<IFileSpec> fileSpecs) throws ConnectionException, AccessException {
        return this.whereDelegator.where(fileSpecs);
    }

    @Override
    public List<IFileSpec> localWhere(List<IFileSpec> fileSpecs) {
        return this.whereDelegator.localWhere(fileSpecs);
    }

    @Override
    public List<IFileSpec> openedFiles(List<IFileSpec> fileSpecs, int maxFiles, int changeListId) throws ConnectionException, AccessException {
        try {
            return this.openedFiles(fileSpecs, new OpenedFilesOptions(false, this.getName(), maxFiles, null, changeListId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.openedFiless: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> openedFiles(List<IFileSpec> fileSpecs, OpenedFilesOptions opts) throws P4JavaException {
        if (opts == null) {
            return this.serverImpl.getOpenedFiles(fileSpecs, new OpenedFilesOptions().setClientName(this.name));
        }
        if (opts.getOptions() != null) {
            List<String> optsStrings = opts.getOptions();
            return this.serverImpl.getOpenedFiles(fileSpecs, new OpenedFilesOptions(optsStrings.toArray(new String[optsStrings.size()])));
        }
        return this.serverImpl.getOpenedFiles(fileSpecs, opts.setAllClients(false).setClientName(this.getName()));
    }

    @Override
    public List<IFileSpec> integrateFiles(int changeListId, boolean showActionsOnly, IntegrationOptions integOpts, String branchSpec, IFileSpec fromFile, IFileSpec toFile) throws ConnectionException, AccessException {
        try {
            if (integOpts == null) {
                integOpts = new IntegrationOptions();
            }
            boolean integrateAroundDeletedRevs = false;
            boolean rebranchSourceAfterDelete = false;
            boolean deleteTargetAfterDelete = false;
            boolean integrateAllAfterReAdd = false;
            String[] deleteOpts = integOpts.getDeletedOptions();
            if (deleteOpts != null) {
                for (String opt : deleteOpts) {
                    if (opt == null) continue;
                    if (opt.equals("d")) {
                        integrateAroundDeletedRevs = true;
                    }
                    if (opt.equals("Di")) {
                        integrateAllAfterReAdd = true;
                    }
                    if (opt.equals("Dt")) {
                        rebranchSourceAfterDelete = true;
                    }
                    if (!opt.equals("Ds")) continue;
                    deleteTargetAfterDelete = true;
                }
            }
            return this.integrateFiles(fromFile, toFile, branchSpec, new IntegrateFilesOptions(changeListId, integOpts.isBidirectionalInteg(), integrateAroundDeletedRevs, rebranchSourceAfterDelete, deleteTargetAfterDelete, integrateAllAfterReAdd, integOpts.isForce(), integOpts.isUseHaveRev(), integOpts.isBaselessMerge(), integOpts.isDisplayBaseDetails(), showActionsOnly, integOpts.isReverseMapping(), integOpts.isPropagateType(), integOpts.isDontCopyToClient(), integOpts.getMaxFiles()));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.integrateFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> integrateFiles(IFileSpec fromFile, IFileSpec toFile, String branchSpec, IntegrateFilesOptions opts) throws P4JavaException {
        IClient currentClient = this.serverImpl.getCurrentClient();
        this.serverImpl.setCurrentClient(this);
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.INTEG, Parameters.processParameters((Options)opts, fromFile, toFile, branchSpec, (IServer)this.serverImpl), null);
        this.serverImpl.setCurrentClient(currentClient);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IFileSpec> integrateFiles(IFileSpec fromFile, List<IFileSpec> toFiles, IntegrateFilesOptions opts) throws P4JavaException {
        IClient currentClient = this.serverImpl.getCurrentClient();
        this.serverImpl.setCurrentClient(this);
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.INTEG, Parameters.processParameters((Options)opts, fromFile, toFiles, null, (IServer)this.serverImpl), null);
        this.serverImpl.setCurrentClient(currentClient);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IFileSpec> resolveFilesAuto(List<IFileSpec> fileSpecs, boolean safeMerge, boolean acceptTheirs, boolean acceptYours, boolean showActionsOnly, boolean forceResolve) throws ConnectionException, AccessException {
        try {
            return this.resolveFilesAuto(fileSpecs, new ResolveFilesAutoOptions().setAcceptTheirs(acceptTheirs).setAcceptYours(acceptYours).setForceResolve(forceResolve).setSafeMerge(safeMerge).setShowActionsOnly(showActionsOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.resolveFilesAuto: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> resolveFilesAuto(List<IFileSpec> fileSpecs, ResolveFilesAutoOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.resolveFilesAutoMap(fileSpecs, opts);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public String resolveStreamAuto(ResolveFilesAutoOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.resolveFilesAutoMap(null, opts);
        return ResultMapParser.parseCommandResultMapAsString(resultMaps);
    }

    private List<Map<String, Object>> resolveFilesAutoMap(List<IFileSpec> fileSpecs, ResolveFilesAutoOptions opts) throws P4JavaException {
        String amFlag = null;
        if (opts == null || !opts.isAcceptTheirs() && !opts.isAcceptYours() && !opts.isForceResolve() && !opts.isSafeMerge()) {
            amFlag = "-am";
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.RESOLVE, Parameters.processParameters((Options)opts, fileSpecs, amFlag, (IServer)this.serverImpl), null);
        return resultMaps;
    }

    @Override
    public IFileSpec resolveFile(IFileSpec targetFile, InputStream sourceStream) throws ConnectionException, RequestException, AccessException {
        return this.resolveFile(targetFile, sourceStream, true, -1, -1);
    }

    @Override
    public IFileSpec resolveFile(IFileSpec targetFileSpec, InputStream sourceStream, boolean useTextualMerge, int startFromRev, int endFromRev) throws ConnectionException, RequestException, AccessException {
        if (targetFileSpec == null) {
            throw new NullPointerError("Null target file spec passed to IClient.resolveFile");
        }
        if (sourceStream == null) {
            throw new NullPointerError("Null source stream passed to IClient.resolveFile");
        }
        if (!(this.serverImpl instanceof RpcServer)) {
            throw new RequestException("Request not supported by the current P4Java implementation; use an RPC-based pure Java implementation if possible");
        }
        HashMap<String, Object> resolveMap = new HashMap<String, Object>();
        IFileSpec fileSpec = null;
        File tmpFile = null;
        if (this.serverImpl != null) {
            try {
                String defaultTmpDir = System.getProperty("java.io.tmpdir");
                String tmpDirProp = this.serverImpl.getProperties().getProperty("com.perforce.p4java.tmpDir", defaultTmpDir);
                tmpFile = File.createTempFile("p4java", ".tmp", new File(tmpDirProp));
                if (tmpFile != null) {
                    int bytesRead;
                    FileOutputStream outStream = new FileOutputStream(tmpFile);
                    byte[] bytes = new byte[1024];
                    while ((bytesRead = sourceStream.read(bytes)) > 0) {
                        outStream.write(bytes, 0, bytesRead);
                    }
                    outStream.close();
                    resolveMap.put(MERGE_TMP_FILENAME_KEY, tmpFile.getPath());
                    resolveMap.put(MERGE_START_FROM_REV_KEY, new Integer(startFromRev));
                    resolveMap.put(MERGE_END_FROM_REV_KEY, new Integer(endFromRev));
                }
                ArrayList<String> args = new ArrayList<String>();
                if (useTextualMerge) {
                    args.add("-t");
                }
                int MINIMUM_ACTION_RESOLVE_SERVER_VERSION = 20111;
                if (this.serverImpl.getServerVersionNumber() >= 20111 && (startFromRev != -1 || endFromRev != -1)) {
                    args.add("-Ac");
                }
                args.add(targetFileSpec.getAnnotatedPreferredPathString());
                List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.RESOLVE, args.toArray(new String[0]), resolveMap);
                if (resultMaps != null) {
                    if (resultMaps.size() > 1) {
                        IFileSpec iFileSpec = ResultListBuilder.handleIntegrationFileReturn(resultMaps.get(1), true, this.serverImpl);
                        return iFileSpec;
                    }
                    IFileSpec iFileSpec = ResultListBuilder.handleIntegrationFileReturn(resultMaps.get(0), false, this.serverImpl);
                    return iFileSpec;
                }
            }
            catch (IOException exc) {
                Log.error("local file I/O error on resolve: " + exc.getMessage(), new Object[0]);
                Log.exception(exc);
                throw new P4JavaError("local file I/O error on resolve: " + exc.getMessage());
            }
            finally {
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        return fileSpec;
    }

    @Override
    public List<IFileSpec> resolvedFiles(List<IFileSpec> fileSpecs, boolean showBaseRevision) throws ConnectionException, AccessException {
        try {
            return this.resolvedFiles(fileSpecs, new ResolvedFilesOptions().setShowBaseRevision(showBaseRevision));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.resolvedFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> resolvedFiles(List<IFileSpec> fileSpecs, ResolvedFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.RESOLVED, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IFileSpec> lockFiles(List<IFileSpec> fileSpecs, int changeListId) throws ConnectionException, AccessException {
        try {
            return this.lockFiles(fileSpecs, new LockFilesOptions().setChangelistId(changeListId));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.lockFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> lockFiles(List<IFileSpec> fileSpecs, LockFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> lockedList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.LOCK, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                lockedList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return lockedList;
    }

    @Override
    public List<IFileSpec> unlockFiles(List<IFileSpec> fileSpecs, int changeListId, boolean force) throws ConnectionException, AccessException {
        try {
            return this.unlockFiles(fileSpecs, new UnlockFilesOptions().setChangelistId(changeListId).setForceUnlock(force));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.lockFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> unlockFiles(List<IFileSpec> fileSpecs, UnlockFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> unlockedList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.UNLOCK, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                unlockedList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return unlockedList;
    }

    @Override
    public List<IFileSpec> getDiffFiles(List<IFileSpec> fileSpecs, int maxFiles, boolean diffNonTextFiles, boolean openedDifferentMissing, boolean openedForIntegrate, boolean unopenedMissing, boolean unopenedDifferent, boolean unopenedWithStatus, boolean openedSame) throws ConnectionException, RequestException, AccessException {
        try {
            return this.getDiffFiles(fileSpecs, new GetDiffFilesOptions().setMaxFiles(maxFiles).setDiffNonTextFiles(diffNonTextFiles).setOpenedDifferentMissing(openedDifferentMissing).setOpenedForIntegrate(openedForIntegrate).setUnopenedMissing(unopenedMissing).setUnopenedDifferent(unopenedDifferent).setUnopenedWithStatus(unopenedWithStatus).setOpenedSame(openedSame));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.getDiffFiles: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> getDiffFiles(List<IFileSpec> fileSpecs, GetDiffFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> diffList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.DIFF, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                diffList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return diffList;
    }

    @Override
    public List<IFileSpec> shelveFiles(List<IFileSpec> fileSpecs, int changelistId, ShelveFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        Object changelistString = null;
        if (changelistId == 0) {
            changelistString = "-cdefault";
        } else if (changelistId > 0) {
            changelistString = "-c" + changelistId;
        }
        IClient currentClient = this.serverImpl.getCurrentClient();
        this.serverImpl.setCurrentClient(this);
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.SHELVE, Parameters.processParameters((Options)opts, fileSpecs, (String)changelistString, (IServer)this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        this.serverImpl.setCurrentClient(currentClient);
        return resultList;
    }

    @Override
    public List<IFileSpec> unshelveFiles(List<IFileSpec> fileSpecs, int sourceChangelistId, int targetChangelistId, UnshelveFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (sourceChangelistId <= 0) {
            throw new RequestException("Source changelist ID must be greater than zero");
        }
        String sourceChangelistString = "-s" + sourceChangelistId;
        Object targetChangelistString = null;
        if (targetChangelistId == 0) {
            targetChangelistString = "-cdefault";
        } else if (targetChangelistId > 0) {
            targetChangelistString = "-c" + targetChangelistId;
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.UNSHELVE, Parameters.processParameters((Options)opts, fileSpecs, new String[]{sourceChangelistString, targetChangelistString}, (IServer)this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> shelveChangelist(int changelistId, List<IFileSpec> fileSpecs, boolean forceUpdate, boolean replace, boolean discard) throws ConnectionException, RequestException, AccessException {
        try {
            return this.shelveFiles(fileSpecs, changelistId, new ShelveFilesOptions().setDeleteFiles(discard).setForceShelve(forceUpdate).setReplaceFiles(replace));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.shelveChangelist: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> shelveChangelist(IChangelist list) throws ConnectionException, RequestException, AccessException {
        if (list == null) {
            throw new NullPointerError("Null changelist specification in shelveChangelist method call");
        }
        IClient currentClient = this.serverImpl.getCurrentClient();
        this.serverImpl.setCurrentClient(this);
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.SHELVE, new String[]{"-i"}, InputMapper.map(list, true));
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        this.serverImpl.setCurrentClient(currentClient);
        return resultList;
    }

    @Override
    public List<IFileSpec> unshelveChangelist(int shelveChangelistId, List<IFileSpec> fileSpecs, int clientChangelistId, boolean forceOverwrite, boolean previewOnly) throws ConnectionException, RequestException, AccessException {
        if (shelveChangelistId <= 0) {
            throw new RequestException("Shelve changelist ID must be greater than zero");
        }
        try {
            return this.unshelveFiles(fileSpecs, shelveChangelistId, clientChangelistId, new UnshelveFilesOptions().setForceUnshelve(forceOverwrite).setPreview(previewOnly));
        }
        catch (ConnectionException exc) {
            throw exc;
        }
        catch (AccessException exc) {
            throw exc;
        }
        catch (P4JavaException exc) {
            Log.warn("Unexpected exception in IClient.unshelveChangelist: " + exc, new Object[0]);
            return new ArrayList<IFileSpec>();
        }
    }

    @Override
    public List<IFileSpec> submitShelvedChangelist(int shelvedChangelistId) throws P4JavaException {
        if (shelvedChangelistId <= 0) {
            throw new RequestException("Shelved changelist ID must be greater than zero");
        }
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.SUBMIT, new String[]{"-e", "" + shelvedChangelistId}, null);
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        if (resultMaps != null) {
            for (Map<String, Object> result : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(result, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public List<IFileSpec> copyFiles(IFileSpec fromFile, IFileSpec toFile, String branchSpec, CopyFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.COPY, Parameters.processParameters((Options)opts, fromFile, toFile, branchSpec, (IServer)this.serverImpl), null);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IFileSpec> copyFiles(IFileSpec fromFile, List<IFileSpec> toFiles, CopyFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.COPY, Parameters.processParameters((Options)opts, fromFile, toFiles, null, (IServer)this.serverImpl), null);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IFileSpec> mergeFiles(IFileSpec fromFile, List<IFileSpec> toFiles, MergeFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.MERGE, Parameters.processParameters((Options)opts, fromFile, toFiles, null, (IServer)this.serverImpl), null);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    private List<IFileSpec> getIntegrationFilesFromReturn(List<Map<String, Object>> maps) throws P4JavaException {
        ArrayList<IFileSpec> integList = new ArrayList<IFileSpec>();
        if (maps != null) {
            for (Map<String, Object> result : maps) {
                integList.add(ResultListBuilder.handleIntegrationFileReturn(result, this.serverImpl));
            }
        }
        return integList;
    }

    @Override
    public List<IFileSpec> reconcileFiles(List<IFileSpec> fileSpecs, ReconcileFilesOptions opts) throws P4JavaException {
        ArrayList<IFileSpec> resultList = new ArrayList<IFileSpec>();
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.RECONCILE, Parameters.processParameters(opts, fileSpecs, this.serverImpl), null);
        if (resultMaps != null) {
            for (Map<String, Object> map : resultMaps) {
                resultList.add(ResultListBuilder.handleFileReturn(map, this.serverImpl));
            }
        }
        return resultList;
    }

    @Override
    public void reconcileFiles(List<IFileSpec> fileSpecs, ReconcileFilesOptions opts, IStreamingCallback callback, int key) throws P4JavaException {
        if (this.serverImpl.getCurrentClient() == null || !this.serverImpl.getCurrentClient().getName().equalsIgnoreCase(this.getName())) {
            throw new RequestException("Attempted to reconcile a client that is not the server's current client");
        }
        this.serverImpl.execStreamingMapCommand(CmdSpec.RECONCILE.toString(), Parameters.processParameters(opts, fileSpecs, this.serverImpl), null, callback, key);
    }

    @Override
    public List<IFileSpec> reconcileFiles(ReconcileFilesOptions opts) throws P4JavaException {
        return this.reconcileFiles(null, opts);
    }

    @Override
    public List<IFileSpec> populateFiles(IFileSpec fromFile, List<IFileSpec> toFiles, PopulateFilesOptions opts) throws P4JavaException {
        List<Map<String, Object>> resultMaps = this.serverImpl.execMapCmdList(CmdSpec.POPULATE, Parameters.processParameters((Options)opts, fromFile, toFiles, null, (IServer)this.serverImpl), null);
        return this.getIntegrationFilesFromReturn(resultMaps);
    }

    @Override
    public List<IRepo> getRepos() throws ConnectionException, RequestException, AccessException {
        ReposDelegator reposDelegator = new ReposDelegator(this.serverImpl);
        return reposDelegator.getRepos(this.getName());
    }

    @Override
    public ViewDepotType getViewDepotType() {
        return this.viewDepotType;
    }

    @Override
    public ListData getListData(List<IFileSpec> fileSpecs, ListOptions options) throws P4JavaException {
        ListDelegator listDelegator = new ListDelegator(this.serverImpl);
        return listDelegator.getListData(fileSpecs, options, this.getName());
    }

    @Override
    public String setStreamParentView(IStreamSummary.ParentView parentview, boolean sourceComments) throws P4JavaException {
        if (this.getStream() == null) {
            P4JavaExceptions.throwOptionsException("Missing Stream field", this);
        }
        ArrayList<Object> opts = new ArrayList<Object>();
        opts.add("parentview");
        opts.add("--" + parentview);
        if (sourceComments) {
            opts.add("--source-comments");
        }
        List<Map<String, Object>> result = this.serverImpl.execMapCmdList(CmdSpec.STREAM, Parameters.processParameters(null, null, opts.toArray(new String[0]), (IServer)this.serverImpl), null);
        return ResultMapParser.parseCommandResultMapIfIsInfoMessageAsString(result);
    }
}

