/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.p4java.diff;

public class DiffFlags {
    public Type type = Type.Normal;
    public Sequence sequence = Sequence.Line;
    public Grid grid = Grid.Optimal;
    public int contextCount = 0;

    public DiffFlags(String flags) {
        boolean someDigit = false;
        if (flags == null) {
            return;
        }
        for (char c : flags.toCharArray()) {
            switch (c) {
                case 'a': {
                    break;
                }
                case 'l': {
                    this.sequence = Sequence.DashL;
                    break;
                }
                case 'b': {
                    this.sequence = Sequence.DashB;
                    break;
                }
                case 'w': {
                    this.sequence = Sequence.DashW;
                    break;
                }
                case 'C': 
                case 'c': {
                    this.type = Type.Context;
                    break;
                }
                case 'H': 
                case 'h': {
                    this.type = Type.HTML;
                    this.sequence = Sequence.Word;
                    break;
                }
                case 'v': {
                    this.type = Type.HTML;
                    this.sequence = Sequence.WClass;
                    break;
                }
                case 'n': {
                    this.type = Type.Rcs;
                    break;
                }
                case 's': {
                    this.type = Type.Summary;
                    break;
                }
                case 'U': 
                case 'u': {
                    this.type = Type.Unified;
                    break;
                }
                case 'G': 
                case 'g': {
                    if (this.grid == Grid.Diff3) {
                        this.grid = Grid.GuardedDiff3;
                        break;
                    }
                    this.grid = Grid.Guarded;
                    break;
                }
                case 'X': 
                case 'x': {
                    if (this.grid == Grid.Guarded) {
                        this.grid = Grid.GuardedDiff3;
                        break;
                    }
                    this.grid = Grid.Diff3;
                    break;
                }
                case 'T': 
                case 't': {
                    this.grid = Grid.TwoWay;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.contextCount = this.contextCount * 10 + c - 48;
                    someDigit = true;
                }
            }
            if (someDigit) continue;
            this.contextCount = -1;
        }
    }

    public static enum Grid {
        Optimal,
        Guarded,
        TwoWay,
        Diff3,
        GuardedDiff3;

    }

    public static enum Sequence {
        Line,
        Word,
        DashL,
        DashB,
        DashW,
        WClass;

    }

    public static enum Type {
        Normal,
        Context,
        Unified,
        Rcs,
        HTML,
        Summary;

    }
}

